/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.snp;

import de.fhg.aisec.ids.snp.SnpException;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u0010B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lde/fhg/aisec/ids/snp/SnpConfig;", "", "certificate", "Ljava/security/cert/X509Certificate;", "snpAttestdHost", "", "snpAttestdPort", "", "<init>", "(Ljava/security/cert/X509Certificate;Ljava/lang/String;I)V", "getCertificate", "()Ljava/security/cert/X509Certificate;", "getSnpAttestdHost", "()Ljava/lang/String;", "getSnpAttestdPort", "()I", "Builder", "idscp2-ra-snp"})
public final class SnpConfig {
    @NotNull
    private final X509Certificate certificate;
    @NotNull
    private final String snpAttestdHost;
    private final int snpAttestdPort;

    public SnpConfig(@NotNull X509Certificate certificate, @NotNull String snpAttestdHost, int snpAttestdPort) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)snpAttestdHost, (String)"snpAttestdHost");
        this.certificate = certificate;
        this.snpAttestdHost = snpAttestdHost;
        this.snpAttestdPort = snpAttestdPort;
    }

    public /* synthetic */ SnpConfig(X509Certificate x509Certificate, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "127.0.0.1";
        }
        if ((n2 & 4) != 0) {
            n = 6778;
        }
        this(x509Certificate, string, n);
    }

    @NotNull
    public final X509Certificate getCertificate() {
        return this.certificate;
    }

    @NotNull
    public final String getSnpAttestdHost() {
        return this.snpAttestdHost;
    }

    public final int getSnpAttestdPort() {
        return this.snpAttestdPort;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fhg/aisec/ids/snp/SnpConfig$Builder;", "", "<init>", "()V", "host", "", "port", "", "certificate", "Ljava/security/cert/X509Certificate;", "setCertificate", "value", "setSnpAttestdHost", "setSnpAttestdPort", "build", "Lde/fhg/aisec/ids/snp/SnpConfig;", "idscp2-ra-snp"})
    public static final class Builder {
        @NotNull
        private String host = "127.0.0.1";
        private int port = 6778;
        @Nullable
        private X509Certificate certificate;

        @NotNull
        public final Builder setCertificate(@NotNull X509Certificate value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.certificate = value;
            return this;
        }

        @NotNull
        public final Builder setSnpAttestdHost(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.host = value;
            return this;
        }

        @NotNull
        public final Builder setSnpAttestdPort(int value) {
            this.port = value;
            return this;
        }

        @NotNull
        public final SnpConfig build() {
            X509Certificate x509Certificate = this.certificate;
            if (x509Certificate == null) {
                throw new SnpException("A certificate must be provided", null, 2, null);
            }
            return new SnpConfig(x509Certificate, this.host, this.port);
        }
    }
}

