package de.fhg.aisec.ids.snp

import de.fhg.aisec.ids.snp.SnpAttestdServiceGrpc.getServiceDescriptor
import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic

/**
 * Holder for Kotlin coroutine-based client and server APIs for SnpAttestdService.
 */
public object SnpAttestdServiceGrpcKt {
  public const val SERVICE_NAME: String = SnpAttestdServiceGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = getServiceDescriptor()

  public val getReportMethod:
      MethodDescriptor<SnpAttestdProto.ReportRequest, SnpAttestdProto.ReportResponse>
    @JvmStatic
    get() = SnpAttestdServiceGrpc.getGetReportMethod()

  public val verifyReportMethod:
      MethodDescriptor<SnpAttestdProto.VerifyRequest, SnpAttestdProto.VerifyResponse>
    @JvmStatic
    get() = SnpAttestdServiceGrpc.getVerifyReportMethod()

  /**
   * A stub for issuing RPCs to a(n) SnpAttestdService service as suspending coroutines.
   */
  @StubFor(SnpAttestdServiceGrpc::class)
  public class SnpAttestdServiceCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<SnpAttestdServiceCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): SnpAttestdServiceCoroutineStub =
        SnpAttestdServiceCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun getReport(request: SnpAttestdProto.ReportRequest, headers: Metadata =
        Metadata()): SnpAttestdProto.ReportResponse = unaryRpc(
      channel,
      SnpAttestdServiceGrpc.getGetReportMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun verifyReport(request: SnpAttestdProto.VerifyRequest, headers: Metadata =
        Metadata()): SnpAttestdProto.VerifyResponse = unaryRpc(
      channel,
      SnpAttestdServiceGrpc.getVerifyReportMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the SnpAttestdService service based on Kotlin coroutines.
   */
  public abstract class SnpAttestdServiceCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for SnpAttestdService.getReport.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun getReport(request: SnpAttestdProto.ReportRequest):
        SnpAttestdProto.ReportResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method SnpAttestdService.getReport is unimplemented"))

    /**
     * Returns the response to an RPC for SnpAttestdService.verifyReport.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun verifyReport(request: SnpAttestdProto.VerifyRequest):
        SnpAttestdProto.VerifyResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method SnpAttestdService.verifyReport is unimplemented"))

    final override fun bindService(): ServerServiceDefinition = builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SnpAttestdServiceGrpc.getGetReportMethod(),
      implementation = ::getReport
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = SnpAttestdServiceGrpc.getVerifyReportMethod(),
      implementation = ::verifyReport
    )).build()
  }
}
