/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.cmc.verifier;

import com.google.protobuf.ByteString;
import de.fhg.aisec.ids.cmc.CmcException;
import de.fhg.aisec.ids.cmc.CmcHelper;
import de.fhg.aisec.ids.cmc.verifier.CmcVerifierConfig;
import de.fhg.aisec.ids.cmcinterface.AttestationRequest;
import de.fhg.aisec.ids.cmcinterface.CMCServiceGrpcKt;
import de.fhg.aisec.ids.cmcinterface.Status;
import de.fhg.aisec.ids.cmcinterface.VerificationRequest;
import de.fhg.aisec.ids.cmcinterface.VerificationResponse;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RaVerifierDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RaVerifierFsmListener;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/fhg/aisec/ids/cmc/verifier/CmcVerifier;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RaVerifierDriver;", "Lde/fhg/aisec/ids/cmc/verifier/CmcVerifierConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaVerifierFsmListener;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaVerifierFsmListener;)V", "config", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "delegate", "", "message", "run", "sendRaResult", "verificationResponse", "Lde/fhg/aisec/ids/cmcinterface/VerificationResponse;", "setConfig", "waitForAttestationReport", "Companion", "idscp2-ra-cmc"})
public final class CmcVerifier
extends RaVerifierDriver<CmcVerifierConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<byte[]> queue;
    private CmcVerifierConfig config;
    @NotNull
    public static final String ID = "CMC";
    private static final Logger LOG = LoggerFactory.getLogger(CmcVerifier.class);

    public CmcVerifier(@NotNull RaVerifierFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.queue = new LinkedBlockingQueue();
    }

    public void setConfig(@NotNull CmcVerifierConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delegated CMC prover message to CMC verifier");
        }
        this.queue.add(message);
    }

    private final byte[] waitForAttestationReport() {
        try {
            byte[] byArray = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"queue.take()");
            return byArray;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
            }
            throw new CmcException("Interrupted or invalid message", e);
        }
    }

    private final void sendRaResult(VerificationResponse verificationResponse) {
        RaVerifierFsmListener raVerifierFsmListener = this.getFsmListener();
        byte[] byArray = verificationResponse.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"verificationResponse.toByteArray()");
        raVerifierFsmListener.onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, byArray);
        if (verificationResponse.getStatus() == Status.OK) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Verifier: CMC verification succeed");
            }
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_OK);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Verifier: CMC verification failed");
            }
            this.getFsmListener().onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_FAILED);
        }
    }

    public void run() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generate and send challenge to remote prover");
            }
            byte[] nonce = CmcHelper.INSTANCE.generateNonce(20);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Challenge nonce is: " + nonce);
            }
            AttestationRequest raRequest = AttestationRequest.newBuilder().setNonce(ByteString.copyFrom((byte[])nonce)).build();
            if (LOG.isTraceEnabled()) {
                System.out.println(raRequest);
            }
            RaVerifierFsmListener raVerifierFsmListener = this.getFsmListener();
            byte[] byArray = raRequest.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"raRequest.toByteArray()");
            raVerifierFsmListener.onRaVerifierMessage(InternalControlMessage.RA_VERIFIER_MSG, byArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wait for RAT prover message with attestation response");
            }
            byte[] attestationReport = this.waitForAttestationReport();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got challenge response. Start validation...");
            }
            VerificationRequest verificationRequest = VerificationRequest.newBuilder().setNonce(ByteString.copyFrom((byte[])nonce)).setAttestationReport(ByteString.copyFrom((byte[])attestationReport)).build();
            if (LOG.isTraceEnabled()) {
                System.out.println(verificationRequest);
            }
            Ref.ObjectRef verificationResponse = new Ref.ObjectRef();
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, (Ref.ObjectRef<VerificationResponse>)verificationResponse, verificationRequest, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CmcVerifier this$0;
                final /* synthetic */ Ref.ObjectRef<VerificationResponse> $verificationResponse;
                final /* synthetic */ VerificationRequest $verificationRequest;
                {
                    this.this$0 = $receiver;
                    this.$verificationResponse = $verificationResponse;
                    this.$verificationRequest = $verificationRequest;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = CmcVerifier.access$getConfig$p(this.this$0);
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v0 = null;
                            }
                            v1 = v0.getCmcHost();
                            v2 = CmcVerifier.access$getConfig$p(this.this$0);
                            if (v2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v2 = null;
                            }
                            channel = ManagedChannelBuilder.forAddress((String)v1, (int)v2.getCmcPort()).usePlaintext().build();
                            var4_4 = this.$verificationResponse;
                            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
                            v3 = new CMCServiceGrpcKt.CMCServiceCoroutineStub((Channel)channel, null, 2, null);
                            var3_5 = this.$verificationRequest;
                            Intrinsics.checkNotNullExpressionValue((Object)var3_5, (String)"verificationRequest");
                            this.L$0 = channel;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v4 = CMCServiceGrpcKt.CMCServiceCoroutineStub.verify$default(v3, var3_5, null, (Continuation)this, 2, null);
                            if (v4 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl32
                        }
                        case 1: {
                            var4_4 = (Ref.ObjectRef<VerificationResponse>)this.L$1;
                            channel = (ManagedChannel)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl32:
                            // 2 sources

                            var4_4.element = v4;
                            return Boxing.boxBoolean((boolean)channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            this.sendRaResult((VerificationResponse)verificationResponse.element);
        }
        catch (Throwable t) {
            LOG.error("Error in CMC Verifier", t);
            throw t;
        }
    }

    public static final /* synthetic */ CmcVerifierConfig access$getConfig$p(CmcVerifier $this) {
        return $this.config;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/cmc/verifier/CmcVerifier$Companion;", "", "()V", "ID", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2-ra-cmc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

