/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.cmc.prover;

import de.fhg.aisec.ids.cmc.CmcException;
import de.fhg.aisec.ids.cmc.prover.CmcProverConfig;
import de.fhg.aisec.ids.cmcinterface.AttestationRequest;
import de.fhg.aisec.ids.cmcinterface.AttestationResponse;
import de.fhg.aisec.ids.cmcinterface.CMCServiceGrpcKt;
import de.fhg.aisec.ids.cmcinterface.Status;
import de.fhg.aisec.ids.cmcinterface.VerificationResponse;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RaProverDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RaProverFsmListener;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/fhg/aisec/ids/cmc/prover/CmcProver;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RaProverDriver;", "Lde/fhg/aisec/ids/cmc/prover/CmcProverConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaProverFsmListener;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RaProverFsmListener;)V", "config", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "delegate", "", "message", "run", "setConfig", "waitForVerifierMsg", "Companion", "idscp2-ra-cmc"})
public final class CmcProver
extends RaProverDriver<CmcProverConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<byte[]> queue;
    private CmcProverConfig config;
    @NotNull
    public static final String ID = "CMC";
    private static final Logger LOG = LoggerFactory.getLogger(CmcProver.class);

    public CmcProver(@NotNull RaProverFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.queue = new LinkedBlockingQueue();
    }

    public void setConfig(@NotNull CmcProverConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        if (LOG.isDebugEnabled()) {
            LOG.debug("CMC expected at " + config.getCmcHost() + ":" + config.getCmcPort());
        }
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delegated CMC verifier message to CMC prover");
        }
        this.queue.add(message);
    }

    private final byte[] waitForVerifierMsg() {
        try {
            byte[] byArray = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"queue.take()");
            return byArray;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            }
            throw new CmcException("Interrupted or invalid message", e);
        }
    }

    public void run() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wait for challenge from verifier");
            }
            byte[] ratVerifierMsg = this.waitForVerifierMsg();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got rat challenge from rat verifier. Starting communication...");
            }
            Ref.ObjectRef attestationResponse = new Ref.ObjectRef();
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, (Ref.ObjectRef<AttestationResponse>)attestationResponse, ratVerifierMsg, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ CmcProver this$0;
                final /* synthetic */ Ref.ObjectRef<AttestationResponse> $attestationResponse;
                final /* synthetic */ byte[] $ratVerifierMsg;
                {
                    this.this$0 = $receiver;
                    this.$attestationResponse = $attestationResponse;
                    this.$ratVerifierMsg = $ratVerifierMsg;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = CmcProver.access$getConfig$p(this.this$0);
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v0 = null;
                            }
                            v1 = v0.getCmcHost();
                            v2 = CmcProver.access$getConfig$p(this.this$0);
                            if (v2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                v2 = null;
                            }
                            channel = ManagedChannelBuilder.forAddress((String)v1, (int)v2.getCmcPort()).usePlaintext().build();
                            var4_4 = this.$attestationResponse;
                            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
                            v3 = new CMCServiceGrpcKt.CMCServiceCoroutineStub((Channel)channel, null, 2, null);
                            var3_5 = AttestationRequest.parseFrom(this.$ratVerifierMsg);
                            Intrinsics.checkNotNullExpressionValue((Object)var3_5, (String)"parseFrom(ratVerifierMsg)");
                            this.L$0 = channel;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v4 = CMCServiceGrpcKt.CMCServiceCoroutineStub.attest$default(v3, var3_5, null, (Continuation)this, 2, null);
                            if (v4 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl32
                        }
                        case 1: {
                            var4_4 = (Ref.ObjectRef<AttestationResponse>)this.L$1;
                            channel = (ManagedChannel)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl32:
                            // 2 sources

                            var4_4.element = v4;
                            return Boxing.boxBoolean((boolean)channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got CMC response, send response to verifier");
            }
            RaProverFsmListener raProverFsmListener = this.getFsmListener();
            byte[] byArray = ((AttestationResponse)attestationResponse.element).toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"attestationResponse.toByteArray()");
            raProverFsmListener.onRaProverMessage(InternalControlMessage.RA_PROVER_MSG, byArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wait for RAT result from RAT verifier");
            }
            VerificationResponse verificationResponse = VerificationResponse.parseFrom(this.waitForVerifierMsg());
            if (LOG.isTraceEnabled()) {
                LOG.trace(verificationResponse.toString());
            }
            if (verificationResponse.getStatus() == Status.OK) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prover: CMC attestation succeed");
                }
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_OK);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Prover: CMC attestation failed");
                }
                this.getFsmListener().onRaProverMessage(InternalControlMessage.RA_PROVER_FAILED);
            }
        }
        catch (Throwable t) {
            LOG.error("Error in CMC prover", t);
            throw t;
        }
    }

    public static final /* synthetic */ CmcProverConfig access$getConfig$p(CmcProver $this) {
        return $this.config;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/cmc/prover/CmcProver$Companion;", "", "()V", "ID", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2-ra-cmc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

