/*
 * Decompiled with CFR 0.152.
 */
package de.femtopedia.studip;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.femtopedia.studip.json.Contacts;
import de.femtopedia.studip.json.Course;
import de.femtopedia.studip.json.Courses;
import de.femtopedia.studip.json.Events;
import de.femtopedia.studip.json.Folder;
import de.femtopedia.studip.json.Semester;
import de.femtopedia.studip.json.Semesters;
import de.femtopedia.studip.json.User;
import de.femtopedia.studip.shib.CustomAccessHttpResponse;
import de.femtopedia.studip.shib.OAuthClient;
import de.femtopedia.studip.util.Schedule;
import de.femtopedia.studip.util.ScheduleHelper;
import java.io.IOException;
import oauth.signpost.exception.OAuthException;

public class StudIPAPI {
    private static final String BASE_URL = "https://studip.uni-passau.de/studip/api.php/";
    private OAuthClient oAuthClient = new OAuthClient();
    private Gson gson;

    public StudIPAPI(String consumerKey, String consumerSecret) {
        this.oAuthClient.setupOAuth(consumerKey, consumerSecret);
        this.gson = new GsonBuilder().create();
    }

    public String getAuthorizationUrl(String callback) throws OAuthException {
        return this.oAuthClient.getAuthorizationUrl(callback);
    }

    public void verifyAccess(String verifyToken) throws OAuthException {
        this.oAuthClient.verifyAccess(verifyToken);
    }

    public OAuthClient getOAuthClient() {
        return this.oAuthClient;
    }

    public boolean isSessionValid() throws IOException, OAuthException {
        return this.oAuthClient.isSessionValid();
    }

    public CustomAccessHttpResponse get(String url) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.oAuthClient.get(BASE_URL + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getData(String apiUrl, Class<T> objClass) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        try (CustomAccessHttpResponse response = null;){
            response = this.get(apiUrl);
            if (response.getResponse().code() == 404) {
                throw new IllegalAccessException("Not found!");
            }
            if (!response.getResponse().body().contentType().subtype().equals("json")) {
                throw new IllegalAccessException("Session is not valid!");
            }
            Object object = this.gson.fromJson(response.readLine(), objClass);
            return (T)object;
        }
    }

    public User getCurrentUserData() throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("user", User.class);
    }

    public User getUserData(String userID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("user/" + userID, User.class);
    }

    public Contacts getContacts(String userID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("user/" + userID + "/contacts", Contacts.class);
    }

    public Events getEvents(String userID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("user/" + userID + "/events", Events.class);
    }

    public Course getCourse(String courseID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("course/" + courseID, Course.class);
    }

    public Courses getCourses(String userID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("user/" + userID + "/courses", Courses.class);
    }

    public Folder getCourseTopFolder(String courseID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("course/" + courseID + "/top_folder", Folder.class);
    }

    public Semesters getSemesters() throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("semesters", Semesters.class);
    }

    public Semester getSemester(String semesterID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("semester/" + semesterID, Semester.class);
    }

    @Deprecated
    public Schedule getSchedule() throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return ScheduleHelper.getData(this);
    }

    public de.femtopedia.studip.json.Schedule getSchedule(String userID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("user/" + userID + "/schedule", de.femtopedia.studip.json.Schedule.class);
    }

    public de.femtopedia.studip.json.Schedule getSchedule(String userID, String semesterID) throws IOException, IllegalArgumentException, IllegalAccessException, OAuthException {
        return this.getData("user/" + userID + "/schedule/" + semesterID, de.femtopedia.studip.json.Schedule.class);
    }
}

