/*
 * Decompiled with CFR 0.152.
 */
package de.femtopedia.studip.json;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.femtopedia.studip.json.ScheduledCourse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonAdapter(value=ScheduleAdapter.class)
public class Schedule {
    private Map<String, ScheduledCourse> monday;
    private Map<String, ScheduledCourse> tuesday;
    private Map<String, ScheduledCourse> wednesday;
    private Map<String, ScheduledCourse> thursday;
    private Map<String, ScheduledCourse> friday;
    private Map<String, ScheduledCourse> saturday;
    private Map<String, ScheduledCourse> sunday;

    public Map<String, ScheduledCourse> getDay(int day) {
        switch (day % 7) {
            case 0: {
                return this.monday;
            }
            case 1: {
                return this.tuesday;
            }
            case 2: {
                return this.wednesday;
            }
            case 3: {
                return this.thursday;
            }
            case 4: {
                return this.friday;
            }
            case 5: {
                return this.saturday;
            }
            case 6: {
                return this.sunday;
            }
        }
        return null;
    }

    protected Schedule(Map<String, ScheduledCourse> monday, Map<String, ScheduledCourse> tuesday, Map<String, ScheduledCourse> wednesday, Map<String, ScheduledCourse> thursday, Map<String, ScheduledCourse> friday, Map<String, ScheduledCourse> saturday, Map<String, ScheduledCourse> sunday) {
        this.monday = monday;
        this.tuesday = tuesday;
        this.wednesday = wednesday;
        this.thursday = thursday;
        this.friday = friday;
        this.saturday = saturday;
        this.sunday = sunday;
    }

    public Map<String, ScheduledCourse> getMonday() {
        return this.monday;
    }

    public Map<String, ScheduledCourse> getTuesday() {
        return this.tuesday;
    }

    public Map<String, ScheduledCourse> getWednesday() {
        return this.wednesday;
    }

    public Map<String, ScheduledCourse> getThursday() {
        return this.thursday;
    }

    public Map<String, ScheduledCourse> getFriday() {
        return this.friday;
    }

    public Map<String, ScheduledCourse> getSaturday() {
        return this.saturday;
    }

    public Map<String, ScheduledCourse> getSunday() {
        return this.sunday;
    }

    public String toString() {
        return "Schedule(monday=" + this.getMonday() + ", tuesday=" + this.getTuesday() + ", wednesday=" + this.getWednesday() + ", thursday=" + this.getThursday() + ", friday=" + this.getFriday() + ", saturday=" + this.getSaturday() + ", sunday=" + this.getSunday() + ")";
    }

    class ScheduleAdapter
    extends TypeAdapter<Schedule> {
        ScheduleAdapter() {
        }

        public void write(JsonWriter jsonWriter, Schedule schedule) throws IOException {
            jsonWriter.beginArray();
            for (int i = 0; i < 7; ++i) {
                Map<String, ScheduledCourse> day = schedule.getDay(i);
                jsonWriter.beginObject();
                for (Map.Entry<String, ScheduledCourse> entry : day.entrySet()) {
                    jsonWriter.name(entry.getKey());
                    jsonWriter.beginObject();
                    ScheduledCourse c = entry.getValue();
                    jsonWriter.name("start");
                    jsonWriter.value((long)c.getStart());
                    jsonWriter.name("end");
                    jsonWriter.value((long)c.getEnd());
                    jsonWriter.name("content");
                    jsonWriter.value(c.getContent());
                    jsonWriter.name("title");
                    jsonWriter.value(c.getTitle());
                    jsonWriter.name("color");
                    jsonWriter.value(c.getColor());
                    jsonWriter.name("type");
                    jsonWriter.value(c.getType());
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }

        public Schedule read(JsonReader jsonReader) throws IOException {
            Schedule sched = new Schedule(new HashMap<String, ScheduledCourse>(), new HashMap<String, ScheduledCourse>(), new HashMap<String, ScheduledCourse>(), new HashMap<String, ScheduledCourse>(), new HashMap<String, ScheduledCourse>(), new HashMap<String, ScheduledCourse>(), new HashMap<String, ScheduledCourse>());
            jsonReader.beginArray();
            int day = 0;
            while (jsonReader.hasNext()) {
                boolean object;
                Map<String, ScheduledCourse> daySched = sched.getDay(day);
                boolean bl = object = jsonReader.peek() == JsonToken.BEGIN_OBJECT;
                if (object) {
                    jsonReader.beginObject();
                } else {
                    jsonReader.beginArray();
                }
                while (jsonReader.hasNext()) {
                    String name = jsonReader.nextName();
                    jsonReader.beginObject();
                    jsonReader.nextName();
                    int start = jsonReader.nextInt();
                    jsonReader.nextName();
                    int end = jsonReader.nextInt();
                    jsonReader.nextName();
                    String content = jsonReader.nextString();
                    jsonReader.nextName();
                    String title = jsonReader.nextString();
                    jsonReader.nextName();
                    String color = jsonReader.nextString();
                    jsonReader.nextName();
                    String type = jsonReader.nextString();
                    daySched.put(name, new ScheduledCourse(start, end, content, title, color, type));
                    jsonReader.endObject();
                }
                if (object) {
                    jsonReader.endObject();
                } else {
                    jsonReader.endArray();
                }
                ++day;
            }
            jsonReader.endArray();
            return sched;
        }
    }
}

