/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class LambadaNameSafeClassAdapter
extends ClassRemapper {
    public String getClassName() {
        return this.remapper.mapType(this.className);
    }

    public LambadaNameSafeClassAdapter(ClassVisitor cv) {
        super(cv, new Remapper(){

            private String fixName(String name) {
                if (name != null) {
                    return name.replace('-', '_');
                }
                return null;
            }

            private String[] fixNames(String[] names) {
                if (names != null) {
                    String[] ret = new String[names.length];
                    for (int i = 0; i < names.length; ++i) {
                        ret[i] = this.fixName(names[i]);
                    }
                    return ret;
                }
                return null;
            }

            public String mapType(String type) {
                return super.mapType(this.fixName(type));
            }

            public String mapInnerClassName(String name, String ownerName, String innerName) {
                return super.mapInnerClassName(this.fixName(name), this.fixName(ownerName), this.fixName(innerName));
            }

            public String mapAnnotationAttributeName(String descriptor, String name) {
                return super.mapAnnotationAttributeName(this.fixName(descriptor), this.fixName(name));
            }

            public String mapFieldName(String owner, String name, String descriptor) {
                return super.mapFieldName(this.fixName(owner), this.fixName(name), descriptor);
            }

            public String mapMethodName(String owner, String name, String descriptor) {
                return super.mapMethodName(this.fixName(owner), this.fixName(name), descriptor);
            }

            public String mapInvokeDynamicMethodName(String name, String descriptor) {
                return super.mapInvokeDynamicMethodName(this.fixName(name), descriptor);
            }

            public String mapModuleName(String name) {
                return super.mapModuleName(this.fixName(name));
            }

            public String mapPackageName(String name) {
                return super.mapPackageName(this.fixName(name));
            }

            public String mapRecordComponentName(String owner, String name, String descriptor) {
                return super.mapRecordComponentName(this.fixName(owner), this.fixName(name), descriptor);
            }

            public String[] mapTypes(String[] internalNames) {
                return super.mapTypes(this.fixNames(internalNames));
            }

            public String map(String internalName) {
                return super.map(this.fixName(internalName));
            }
        });
    }
}

