/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.signapk;

import com.googlecode.d2j.signapk.AbstractJarSign;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class SunJarSignImpl
extends AbstractJarSign {
    protected final X509Certificate cert;

    public SunJarSignImpl(X509Certificate cert, PrivateKey privateKey) {
        super(privateKey);
        this.cert = cert;
    }

    @Override
    protected void writeSignatureBlock(byte[] signature, OutputStream out) throws IOException {
        try {
            Class<?> x500NameClass = Class.forName("sun.security.x509.X500Name");
            Class<?> algorithmIdClass = Class.forName("sun.security.x509.AlgorithmId");
            Class<?> contentInfoClass = Class.forName("sun.security.pkcs.ContentInfo");
            Class<?> signerInfoClass = Class.forName("sun.security.pkcs.SignerInfo");
            Class<?> pkcs7Class = Class.forName("sun.security.pkcs.PKCS7");
            Class<?> objectIdentifierClass = Class.forName("sun.security.util.ObjectIdentifier");
            Class<?> derValueClass = Class.forName("sun.security.util.DerValue");
            Constructor<?> x500NameConstructor = x500NameClass.getConstructor(String.class);
            Method algorithmIdConstructor = algorithmIdClass.getMethod("get", String.class);
            Constructor<?> contentInfoConstructor = contentInfoClass.getConstructor(objectIdentifierClass, derValueClass);
            Constructor<?> signerInfoConstructor = signerInfoClass.getConstructor(x500NameClass, BigInteger.class, algorithmIdClass, algorithmIdClass, byte[].class);
            Constructor<?> pkcs7Constructor = null;
            for (Constructor<?> c : pkcs7Class.getConstructors()) {
                Class<?>[] types;
                if (c.getParameterCount() != 4 || !(types = c.getParameterTypes())[0].isArray() || types[1] != contentInfoClass || types[2] != X509Certificate[].class || !types[3].isArray()) continue;
                pkcs7Constructor = c;
                break;
            }
            if (pkcs7Constructor == null) {
                throw new NoSuchAlgorithmException("PKCS7 constructor not found");
            }
            Object x500Name = x500NameConstructor.newInstance(this.cert.getIssuerX500Principal().getName());
            Object digestAlgorithmId = algorithmIdConstructor.invoke(null, this.digestAlg);
            Object signatureAlgorithmId = algorithmIdConstructor.invoke(null, "RSA");
            Object signerInfo = signerInfoConstructor.newInstance(x500Name, this.cert.getSerialNumber(), digestAlgorithmId, signatureAlgorithmId, signature);
            Object algorithms = Array.newInstance(algorithmIdClass, 1);
            Array.set(algorithms, 0, digestAlgorithmId);
            Field dataOIDField = contentInfoClass.getField("DATA_OID");
            Object dataOID = dataOIDField.get(null);
            if (dataOID == null) {
                throw new IOException("DATA_OID is null");
            }
            Object contentInfo = contentInfoConstructor.newInstance(dataOID, null);
            X509Certificate[] certificates = new X509Certificate[]{this.cert};
            Object signerInfos = Array.newInstance(signerInfoClass, 1);
            Array.set(signerInfos, 0, signerInfo);
            Object pkcs7 = pkcs7Constructor.newInstance(algorithms, contentInfo, certificates, signerInfos);
            Method encodeSignedDataMethod = pkcs7Class.getMethod("encodeSignedData", OutputStream.class);
            encodeSignedDataMethod.invoke(pkcs7, out);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

