/*
 * Decompiled with CFR 0.152.
 */
package de.felixsfd.EnhancedProperties;

import de.felixsfd.EnhancedProperties.ChangedPropertyEvent;
import de.felixsfd.EnhancedProperties.ChangedPropertyListener;
import de.felixsfd.EnhancedProperties.EnhancedProperties;
import de.felixsfd.EnhancedProperties.EnhancedPropertiesImpl;
import de.felixsfd.EnhancedProperties.EnhancedWriteableProperties;
import de.felixsfd.EnhancedProperties.exceptions.EPSetPropertyException;
import de.felixsfd.EnhancedProperties.exceptions.EPTypeNotSupportedException;
import de.felixsfd.EnhancedProperties.utils.EPStringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedWriteablePropertiesImpl
extends EnhancedPropertiesImpl
implements EnhancedWriteableProperties {
    @Nullable
    private Set<ChangedPropertyListener> changedPropertyListeners = null;

    protected void setValue(@NotNull String key, @Nullable Object value) throws EPTypeNotSupportedException, EPSetPropertyException {
        Object originalValue = this.getValue(key, value != null ? value.getClass() : String.class);
        this.setString(key, String.valueOf(value));
        this.propertyChanged(key, originalValue, value);
    }

    private void setValueInternal(@NotNull String key, @Nullable Object value) throws EPSetPropertyException {
        try {
            this.setValue(key, value);
        }
        catch (EPTypeNotSupportedException e) {
            throw new EPSetPropertyException(this, "The property " + key + " could not be set: " + e.getMessage(), e);
        }
    }

    protected Object getValue(String key, Class<?> type) throws EPTypeNotSupportedException {
        String getterName = this.getGetterName(type);
        try {
            Method getter = EnhancedProperties.class.getDeclaredMethod(getterName, String.class);
            return getter.invoke((Object)this, key);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (e instanceof InvocationTargetException && cause instanceof NullPointerException) {
                return null;
            }
            throw new EPTypeNotSupportedException((EnhancedProperties)this, type, (Throwable)e);
        }
    }

    @NotNull
    private String getGetterName(@NotNull Class<?> type) {
        Class classOrPrimitive = ClassUtils.wrapperToPrimitive(type);
        classOrPrimitive = classOrPrimitive == null ? type : classOrPrimitive;
        String typeName = classOrPrimitive.getSimpleName().toLowerCase();
        return "get" + EPStringUtils.firstLetterUppercase(typeName);
    }

    @Override
    public final void setShort(@NotNull String key, short value) throws EPSetPropertyException {
        this.setValueInternal(key, value);
    }

    @Override
    public final void setInt(@NotNull String key, int value) throws EPSetPropertyException {
        this.setValueInternal(key, value);
    }

    @Override
    public final void setLong(@NotNull String key, long value) throws EPSetPropertyException {
        this.setValueInternal(key, value);
    }

    @Override
    public final void setFloat(@NotNull String key, float value) throws EPSetPropertyException {
        this.setValueInternal(key, Float.valueOf(value));
    }

    @Override
    public final void setDouble(@NotNull String key, double value) throws EPSetPropertyException {
        this.setValueInternal(key, value);
    }

    @Override
    public final void setBoolean(@NotNull String key, boolean value) throws EPSetPropertyException {
        this.setValueInternal(key, value);
    }

    protected final void callChangedPropertyListeners(@NotNull ChangedPropertyEvent<?> event) {
        Iterable changedPropertyListeners = this.getChangedPropertyListeners();
        changedPropertyListeners.forEach(listener -> listener.propertyChanged(event));
    }

    protected final void propertyChanged(String key, Object originalValue, Object newValue) {
        ChangedPropertyEvent<Object> event = new ChangedPropertyEvent<Object>(this, key, originalValue, newValue);
        this.callChangedPropertyListeners(event);
    }

    @NotNull
    public Set<ChangedPropertyListener> getChangedPropertyListeners() {
        if (this.changedPropertyListeners == null) {
            this.changedPropertyListeners = new HashSet<ChangedPropertyListener>();
        }
        return this.changedPropertyListeners;
    }

    @Override
    public void addChangedPropertyListener(@NotNull ChangedPropertyListener changedPropertyListener) {
        this.getChangedPropertyListeners().add(changedPropertyListener);
    }
}

