/*
 * Decompiled with CFR 0.152.
 */
package de.felixsfd.EnhancedProperties;

import de.felixsfd.EnhancedProperties.EnhancedPropertiesImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedPropertiesInResources
extends EnhancedPropertiesImpl {
    @NotNull
    private final String resourcesPath;
    @NotNull
    private Properties propertiesInResources;

    protected EnhancedPropertiesInResources(@NotNull String resourcesPath) throws IOException {
        this.resourcesPath = resourcesPath;
        this.propertiesInResources = EnhancedPropertiesInResources.readFromResources(resourcesPath);
    }

    @NotNull
    static Properties readFromResources(@NotNull String path) throws IOException {
        Properties prop = new Properties();
        try (InputStream fis = EnhancedPropertiesInResources.class.getClassLoader().getResourceAsStream(path);){
            prop.load(fis);
        }
        return prop;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        return this.getString(key, null);
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String defaultValue) {
        return this.propertiesInResources.getProperty(key, defaultValue);
    }

    @NotNull
    public String getResourcesPath() {
        return this.resourcesPath;
    }
}

