/*
 * Decompiled with CFR 0.152.
 */
package de.felixsfd.EnhancedProperties;

import de.felixsfd.EnhancedProperties.EnhancedPropertiesInFile;
import de.felixsfd.EnhancedProperties.EnhancedPropertiesInResources;
import de.felixsfd.EnhancedProperties.EnhancedWriteablePropertiesImpl;
import de.felixsfd.EnhancedProperties.annotations.ReadRule;
import de.felixsfd.EnhancedProperties.core.SortedProperties;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedPropertiesInFileOrResources
extends EnhancedWriteablePropertiesImpl {
    @NotNull
    private final String filePath;
    @NotNull
    private final String resourcesPath;
    @NotNull
    private final SortedProperties propertiesFile;
    @NotNull
    private final Properties propertiesResources;

    protected EnhancedPropertiesInFileOrResources(@NotNull String filePath, @NotNull String resourcesPath) throws IOException {
        SortedProperties newFileProperties;
        this.filePath = filePath;
        this.resourcesPath = resourcesPath;
        try {
            newFileProperties = EnhancedPropertiesInFile.readFromFiles(filePath);
        }
        catch (FileNotFoundException e) {
            if (this.getReadRule() != ReadRule.Location.FILE) {
                throw e;
            }
            newFileProperties = new SortedProperties();
        }
        this.propertiesFile = newFileProperties;
        this.propertiesResources = EnhancedPropertiesInResources.readFromResources(resourcesPath);
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        return this.getString(key, null);
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String defaultValue) {
        ReadRule.Location rule = this.getReadRule();
        switch (rule) {
            case FILE: {
                String fileValue = this.propertiesFile.getProperty(key);
                if (fileValue == null) {
                    return this.propertiesResources.getProperty(key, defaultValue);
                }
                return fileValue;
            }
            case RESOURCES: {
                String resourcesValue = this.propertiesResources.getProperty(key);
                if (resourcesValue == null) {
                    return this.propertiesFile.getProperty(key, defaultValue);
                }
                return resourcesValue;
            }
        }
        return defaultValue;
    }

    @Override
    public void setString(@NotNull String key, @Nullable String value) {
        String originalStr = this.getString(key, null);
        this.propertiesFile.put(key, value);
        this.propertyChanged(key, originalStr, value);
    }

    private ReadRule.Location getReadRule() {
        if (this.getClass().isAnnotationPresent(ReadRule.class)) {
            return this.getClass().getAnnotation(ReadRule.class).preferredLocation();
        }
        return ReadRule.DEFAULT_LOCATION;
    }

    @NotNull
    public String getResourcesPath() {
        return this.resourcesPath;
    }

    @NotNull
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void save() throws IOException {
        this.save(this.getFilePath());
    }

    @Override
    public void save(@NotNull String filePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            this.propertiesFile.store(fos, "Generated by de.felixsfd.EnhancedProperties");
        }
    }
}

