/*
 * Decompiled with CFR 0.152.
 */
package de.felixsfd.EnhancedProperties;

import de.felixsfd.EnhancedProperties.EnhancedWriteablePropertiesImpl;
import de.felixsfd.EnhancedProperties.core.SortedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedPropertiesInFile
extends EnhancedWriteablePropertiesImpl {
    @NotNull
    private final String path;
    @NotNull
    private final SortedProperties propertiesInFile;

    protected EnhancedPropertiesInFile(@NotNull String path) throws IOException {
        this.path = path;
        this.propertiesInFile = EnhancedPropertiesInFile.readFromFiles(path);
    }

    @NotNull
    static SortedProperties readFromFiles(@NotNull String path) throws IOException {
        SortedProperties prop = new SortedProperties();
        try (FileInputStream fis = new FileInputStream(new File(path));){
            prop.load(fis);
        }
        return prop;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        return this.getString(key, null);
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String defaultValue) {
        return this.propertiesInFile.getProperty(key, defaultValue);
    }

    @Override
    public void setString(@NotNull String key, String value) {
        String originalStr = this.getString(key, null);
        this.propertiesInFile.put(key, value);
        this.propertyChanged(key, originalStr, value);
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    public void save() throws IOException {
        this.save(this.getPath());
    }

    @Override
    public void save(@NotNull String filePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            this.propertiesInFile.store(fos, "Generated by de.felixsfd.EnhancedProperties");
        }
    }
}

