/*
 * Decompiled with CFR 0.152.
 */
package de.felixsfd.EnhancedProperties;

import de.felixsfd.EnhancedProperties.EnhancedProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

abstract class EnhancedPropertiesImpl
implements EnhancedProperties {
    protected EnhancedPropertiesImpl() {
    }

    @Override
    public final short getShort(@NotNull String key) throws NumberFormatException, NullPointerException {
        String valueStr = this.getString(key);
        return Short.parseShort(Objects.requireNonNull(valueStr));
    }

    @Override
    public final short getShort(@NotNull String key, short defaultValue) {
        String valueStr = this.getString(key);
        if (valueStr == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(valueStr);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public final int getInt(@NotNull String key) throws NumberFormatException, NullPointerException {
        String valueStr = this.getString(key);
        return Integer.parseInt(Objects.requireNonNull(valueStr));
    }

    @Override
    public final int getInt(@NotNull String key, int defaultValue) {
        String valueStr = this.getString(key);
        if (valueStr == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public final long getLong(@NotNull String key) throws NumberFormatException, NullPointerException {
        String valueStr = this.getString(key);
        return Long.parseLong(Objects.requireNonNull(valueStr));
    }

    @Override
    public final long getLong(@NotNull String key, long defaultValue) {
        String valueStr = this.getString(key);
        if (valueStr == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueStr);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public final float getFloat(@NotNull String key) throws NumberFormatException, NullPointerException {
        String valueStr = this.getString(key);
        return Float.parseFloat(Objects.requireNonNull(valueStr));
    }

    @Override
    public final float getFloat(@NotNull String key, float defaultValue) {
        String valueStr = this.getString(key);
        if (valueStr == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueStr);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public final double getDouble(@NotNull String key) throws NumberFormatException, NullPointerException {
        String valueStr = this.getString(key);
        return Double.parseDouble(Objects.requireNonNull(valueStr));
    }

    @Override
    public final double getDouble(@NotNull String key, double defaultValue) {
        String valueStr = this.getString(key);
        if (valueStr == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(valueStr);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(@NotNull String key) {
        String valueStr = this.getString(key);
        return Boolean.parseBoolean(Objects.requireNonNull(valueStr));
    }

    @Override
    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        String valueStr = this.getString(key);
        if (valueStr == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(valueStr);
    }
}

