/*
 * Decompiled with CFR 0.152.
 */
package de.felixschulze.teamcity;

import de.felixschulze.teamcity.TeamCityImportDataType;
import de.felixschulze.teamcity.TeamCityProgressType;
import de.felixschulze.teamcity.TeamCityStatusType;

public class TeamCityStatusMessageHelper {
    public static String escapeString(String string) {
        String tmp = string.replace("|", "||");
        tmp = tmp.replace("'", "|'");
        tmp = tmp.replace("\"", "|'");
        tmp = tmp.replaceAll("\\n", "|n");
        tmp = tmp.replaceAll("\\r", "|r");
        tmp = tmp.replace("[", "|[");
        tmp = tmp.replace("]", "|]");
        return tmp;
    }

    public static String buildNumberString(String version) {
        return "##teamcity[buildNumber '" + TeamCityStatusMessageHelper.escapeString(version) + "']";
    }

    public static String buildStatusString(TeamCityStatusType type, String text) {
        return "##teamcity[buildStatus status='" + type.toString() + "' text='" + TeamCityStatusMessageHelper.escapeString(text) + "']";
    }

    public static String buildStatusFailureString(TeamCityStatusType type, String text) {
        return TeamCityStatusMessageHelper.buildStatusString(type, text);
    }

    public static String buildMessageString(TeamCityStatusType type, String text, String errorDetails) {
        if (type == TeamCityStatusType.ERROR) {
            return "##teamcity[message text='" + TeamCityStatusMessageHelper.escapeString(text) + "' errorDetails='" + TeamCityStatusMessageHelper.escapeString(errorDetails) + "' status='" + type.toString() + "']";
        }
        return "##teamcity[message status='" + type.toString() + "' text='" + TeamCityStatusMessageHelper.escapeString(text) + "']";
    }

    public static String buildProgressString(TeamCityProgressType type, String text) {
        if (type == TeamCityProgressType.START) {
            return "##teamcity[progressStart '" + TeamCityStatusMessageHelper.escapeString(text) + "']";
        }
        if (type == TeamCityProgressType.FINISH) {
            return "##teamcity[progressFinish '" + TeamCityStatusMessageHelper.escapeString(text) + "']";
        }
        if (type == TeamCityProgressType.MESSAGE) {
            return "##teamcity[progressMessage '" + TeamCityStatusMessageHelper.escapeString(text) + "']";
        }
        return "";
    }

    public static String importDataString(TeamCityImportDataType type, String path) {
        return "##teamcity[importData type='" + type.toString() + "' path='" + path + "']";
    }
}

