/*
 * Decompiled with CFR 0.152.
 */
package de.fegbers.dependency.maven.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="save", defaultPhase=LifecyclePhase.INITIALIZE)
public class DependencyMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "dependency.";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}/dependencies.properties")
    private String dependencyPropertiesOutputFilePath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties versionProperties = DependencyMojo.createVersionProperties(this.project.getDependencies());
        File propertiesFile = DependencyMojo.gernerateOutputFile(this.project.getBasedir(), this.dependencyPropertiesOutputFilePath);
        if (propertiesFile.exists()) {
            this.getLog().debug((CharSequence)(propertiesFile.getAbsolutePath() + " already exists.. Deleting old version."));
            propertiesFile.delete();
        }
        try {
            Files.createParentDirs((File)propertiesFile);
            OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), Charset.defaultCharset());
            ObjectMapper mapper = new ObjectMapper();
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)outputWriter, (Object)versionProperties);
            ((Writer)outputWriter).close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute dependency-maven-plugin", e);
        }
    }

    private static Properties createVersionProperties(List<Dependency> dependencies) {
        Properties properties = new Properties();
        for (Dependency dependency : dependencies) {
            properties.put(DependencyMojo.createPropertiesKey(dependency), dependency.getVersion());
        }
        return properties;
    }

    private static String createPropertiesKey(Dependency dependency) {
        return PROPERTY_PREFIX + dependency.getManagementKey().replaceAll(":", ".");
    }

    private static File gernerateOutputFile(File baseFile, String pathName) {
        File file = new File(baseFile, pathName);
        File current = new File(pathName);
        if (current.isAbsolute()) {
            return current;
        }
        return file;
    }
}

