/*
 * Decompiled with CFR 0.152.
 */
package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class VHACDVertex
extends NativeObject {
    public static final int SIZEOF;
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static VHACDVertex wrapPointer(long address) {
        return address != 0L ? new VHACDVertex(address) : null;
    }

    public static VHACDVertex arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return VHACDVertex.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected VHACDVertex(long address) {
        super(address);
    }

    public VHACDVertex() {
        this.address = Raw.VHACDVertex();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public double getMX() {
        this.checkNotNull();
        return Raw.getMX(this.address);
    }

    public void setMX(double value) {
        this.checkNotNull();
        Raw.setMX(this.address, value);
    }

    public double getMY() {
        this.checkNotNull();
        return Raw.getMY(this.address);
    }

    public void setMY(double value) {
        this.checkNotNull();
        Raw.setMY(this.address, value);
    }

    public double getMZ() {
        this.checkNotNull();
        return Raw.getMZ(this.address);
    }

    public void setMZ(double value) {
        this.checkNotNull();
        Raw.setMZ(this.address, value);
    }

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDVertex");
        SIZEOF = VHACDVertex.__sizeOf();
    }

    public static class Raw {
        public static native long VHACDVertex();

        public static native void destroy(long var0);

        public static native double getMX(long var0);

        public static native void setMX(long var0, double var2);

        public static native double getMY(long var0);

        public static native void setMY(long var0, double var2);

        public static native double getMZ(long var0);

        public static native void setMZ(long var0, double var2);
    }
}

