/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.vehicle2.PxVehicleFrame;
import physx.vehicle2.PxVehicleScale;

public class PxVehicleSuspensionParams
extends NativeObject {
    public static final int SIZEOF = PxVehicleSuspensionParams.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVehicleSuspensionParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionParams(address) : null;
    }

    public static PxVehicleSuspensionParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVehicleSuspensionParams.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVehicleSuspensionParams(long address) {
        super(address);
    }

    public PxVehicleSuspensionParams() {
        this.address = Raw.PxVehicleSuspensionParams();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxTransform getSuspensionAttachment() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getSuspensionAttachment(this.address));
    }

    public void setSuspensionAttachment(PxTransform value) {
        this.checkNotNull();
        Raw.setSuspensionAttachment(this.address, value.getAddress());
    }

    public PxVec3 getSuspensionTravelDir() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getSuspensionTravelDir(this.address));
    }

    public void setSuspensionTravelDir(PxVec3 value) {
        this.checkNotNull();
        Raw.setSuspensionTravelDir(this.address, value.getAddress());
    }

    public float getSuspensionTravelDist() {
        this.checkNotNull();
        return Raw.getSuspensionTravelDist(this.address);
    }

    public void setSuspensionTravelDist(float value) {
        this.checkNotNull();
        Raw.setSuspensionTravelDist(this.address, value);
    }

    public PxTransform getWheelAttachment() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getWheelAttachment(this.address));
    }

    public void setWheelAttachment(PxTransform value) {
        this.checkNotNull();
        Raw.setWheelAttachment(this.address, value.getAddress());
    }

    public PxVehicleSuspensionParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        this.checkNotNull();
        return PxVehicleSuspensionParams.wrapPointer(Raw.transformAndScale(this.address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native long PxVehicleSuspensionParams();

        public static native void destroy(long var0);

        public static native long getSuspensionAttachment(long var0);

        public static native void setSuspensionAttachment(long var0, long var2);

        public static native long getSuspensionTravelDir(long var0);

        public static native void setSuspensionTravelDir(long var0, long var2);

        public static native float getSuspensionTravelDist(long var0);

        public static native void setSuspensionTravelDist(long var0, float var2);

        public static native long getWheelAttachment(long var0);

        public static native void setWheelAttachment(long var0, long var2);

        public static native long transformAndScale(long var0, long var2, long var4, long var6, long var8);

        public static native boolean isValid(long var0);
    }
}

