/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.vehicle2.PxVehicleFrame;

public class PxVehicleRigidBodyState
extends NativeObject {
    public static final int SIZEOF = PxVehicleRigidBodyState.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVehicleRigidBodyState wrapPointer(long address) {
        return address != 0L ? new PxVehicleRigidBodyState(address) : null;
    }

    public static PxVehicleRigidBodyState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVehicleRigidBodyState.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVehicleRigidBodyState(long address) {
        super(address);
    }

    public PxVehicleRigidBodyState() {
        this.address = Raw.PxVehicleRigidBodyState();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxTransform getPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getPose(this.address));
    }

    public void setPose(PxTransform value) {
        this.checkNotNull();
        Raw.setPose(this.address, value.getAddress());
    }

    public PxVec3 getLinearVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getLinearVelocity(this.address));
    }

    public void setLinearVelocity(PxVec3 value) {
        this.checkNotNull();
        Raw.setLinearVelocity(this.address, value.getAddress());
    }

    public PxVec3 getAngularVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getAngularVelocity(this.address));
    }

    public void setAngularVelocity(PxVec3 value) {
        this.checkNotNull();
        Raw.setAngularVelocity(this.address, value.getAddress());
    }

    public PxVec3 getPreviousLinearVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getPreviousLinearVelocity(this.address));
    }

    public void setPreviousLinearVelocity(PxVec3 value) {
        this.checkNotNull();
        Raw.setPreviousLinearVelocity(this.address, value.getAddress());
    }

    public PxVec3 getPreviousAngularVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getPreviousAngularVelocity(this.address));
    }

    public void setPreviousAngularVelocity(PxVec3 value) {
        this.checkNotNull();
        Raw.setPreviousAngularVelocity(this.address, value.getAddress());
    }

    public PxVec3 getExternalForce() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getExternalForce(this.address));
    }

    public void setExternalForce(PxVec3 value) {
        this.checkNotNull();
        Raw.setExternalForce(this.address, value.getAddress());
    }

    public PxVec3 getExternalTorque() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getExternalTorque(this.address));
    }

    public void setExternalTorque(PxVec3 value) {
        this.checkNotNull();
        Raw.setExternalTorque(this.address, value.getAddress());
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public float getVerticalSpeed(PxVehicleFrame frame) {
        this.checkNotNull();
        return Raw.getVerticalSpeed(this.address, frame.getAddress());
    }

    public float getLateralSpeed(PxVehicleFrame frame) {
        this.checkNotNull();
        return Raw.getLateralSpeed(this.address, frame.getAddress());
    }

    public float getLongitudinalSpeed(PxVehicleFrame frame) {
        this.checkNotNull();
        return Raw.getLongitudinalSpeed(this.address, frame.getAddress());
    }

    public static class Raw {
        public static native long PxVehicleRigidBodyState();

        public static native void destroy(long var0);

        public static native long getPose(long var0);

        public static native void setPose(long var0, long var2);

        public static native long getLinearVelocity(long var0);

        public static native void setLinearVelocity(long var0, long var2);

        public static native long getAngularVelocity(long var0);

        public static native void setAngularVelocity(long var0, long var2);

        public static native long getPreviousLinearVelocity(long var0);

        public static native void setPreviousLinearVelocity(long var0, long var2);

        public static native long getPreviousAngularVelocity(long var0);

        public static native void setPreviousAngularVelocity(long var0, long var2);

        public static native long getExternalForce(long var0);

        public static native void setExternalForce(long var0, long var2);

        public static native long getExternalTorque(long var0);

        public static native void setExternalTorque(long var0, long var2);

        public static native void setToDefault(long var0);

        public static native float getVerticalSpeed(long var0, long var2);

        public static native float getLateralSpeed(long var0, long var2);

        public static native float getLongitudinalSpeed(long var0, long var2);
    }
}

