/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.vehicle2.PxVehicleFrame;
import physx.vehicle2.PxVehicleScale;
import physx.vehicle2.PxVehicleTorqueCurveLookupTable;

public class PxVehicleEngineParams
extends NativeObject {
    public static final int SIZEOF = PxVehicleEngineParams.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVehicleEngineParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleEngineParams(address) : null;
    }

    public static PxVehicleEngineParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVehicleEngineParams.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVehicleEngineParams(long address) {
        super(address);
    }

    public static PxVehicleEngineParams createAt(long address) {
        Raw.PxVehicleEngineParams_placed(address);
        PxVehicleEngineParams createdObj = PxVehicleEngineParams.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxVehicleEngineParams createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxVehicleEngineParams_placed(address);
        PxVehicleEngineParams createdObj = PxVehicleEngineParams.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxVehicleEngineParams() {
        this.address = Raw.PxVehicleEngineParams();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVehicleTorqueCurveLookupTable getTorqueCurve() {
        this.checkNotNull();
        return PxVehicleTorqueCurveLookupTable.wrapPointer(Raw.getTorqueCurve(this.address));
    }

    public void setTorqueCurve(PxVehicleTorqueCurveLookupTable value) {
        this.checkNotNull();
        Raw.setTorqueCurve(this.address, value.getAddress());
    }

    public float getMoi() {
        this.checkNotNull();
        return Raw.getMoi(this.address);
    }

    public void setMoi(float value) {
        this.checkNotNull();
        Raw.setMoi(this.address, value);
    }

    public float getPeakTorque() {
        this.checkNotNull();
        return Raw.getPeakTorque(this.address);
    }

    public void setPeakTorque(float value) {
        this.checkNotNull();
        Raw.setPeakTorque(this.address, value);
    }

    public float getIdleOmega() {
        this.checkNotNull();
        return Raw.getIdleOmega(this.address);
    }

    public void setIdleOmega(float value) {
        this.checkNotNull();
        Raw.setIdleOmega(this.address, value);
    }

    public float getMaxOmega() {
        this.checkNotNull();
        return Raw.getMaxOmega(this.address);
    }

    public void setMaxOmega(float value) {
        this.checkNotNull();
        Raw.setMaxOmega(this.address, value);
    }

    public float getDampingRateFullThrottle() {
        this.checkNotNull();
        return Raw.getDampingRateFullThrottle(this.address);
    }

    public void setDampingRateFullThrottle(float value) {
        this.checkNotNull();
        Raw.setDampingRateFullThrottle(this.address, value);
    }

    public float getDampingRateZeroThrottleClutchEngaged() {
        this.checkNotNull();
        return Raw.getDampingRateZeroThrottleClutchEngaged(this.address);
    }

    public void setDampingRateZeroThrottleClutchEngaged(float value) {
        this.checkNotNull();
        Raw.setDampingRateZeroThrottleClutchEngaged(this.address, value);
    }

    public float getDampingRateZeroThrottleClutchDisengaged() {
        this.checkNotNull();
        return Raw.getDampingRateZeroThrottleClutchDisengaged(this.address);
    }

    public void setDampingRateZeroThrottleClutchDisengaged(float value) {
        this.checkNotNull();
        Raw.setDampingRateZeroThrottleClutchDisengaged(this.address, value);
    }

    public PxVehicleEngineParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        this.checkNotNull();
        return PxVehicleEngineParams.wrapPointer(Raw.transformAndScale(this.address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native void PxVehicleEngineParams_placed(long var0);

        public static native long PxVehicleEngineParams();

        public static native void destroy(long var0);

        public static native long getTorqueCurve(long var0);

        public static native void setTorqueCurve(long var0, long var2);

        public static native float getMoi(long var0);

        public static native void setMoi(long var0, float var2);

        public static native float getPeakTorque(long var0);

        public static native void setPeakTorque(long var0, float var2);

        public static native float getIdleOmega(long var0);

        public static native void setIdleOmega(long var0, float var2);

        public static native float getMaxOmega(long var0);

        public static native void setMaxOmega(long var0, float var2);

        public static native float getDampingRateFullThrottle(long var0);

        public static native void setDampingRateFullThrottle(long var0, float var2);

        public static native float getDampingRateZeroThrottleClutchEngaged(long var0);

        public static native void setDampingRateZeroThrottleClutchEngaged(long var0, float var2);

        public static native float getDampingRateZeroThrottleClutchDisengaged(long var0);

        public static native void setDampingRateZeroThrottleClutchDisengaged(long var0, float var2);

        public static native long transformAndScale(long var0, long var2, long var4, long var6, long var8);

        public static native boolean isValid(long var0);
    }
}

