/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleAxleDescription
extends NativeObject {
    public static final int SIZEOF = PxVehicleAxleDescription.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVehicleAxleDescription wrapPointer(long address) {
        return address != 0L ? new PxVehicleAxleDescription(address) : null;
    }

    public static PxVehicleAxleDescription arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVehicleAxleDescription.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVehicleAxleDescription(long address) {
        super(address);
    }

    public PxVehicleAxleDescription() {
        this.address = Raw.PxVehicleAxleDescription();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getNbAxles() {
        this.checkNotNull();
        return Raw.getNbAxles(this.address);
    }

    public void setNbAxles(int value) {
        this.checkNotNull();
        Raw.setNbAxles(this.address, value);
    }

    public int getNbWheelsPerAxle(int index) {
        this.checkNotNull();
        return Raw.getNbWheelsPerAxle(this.address, index);
    }

    public void setNbWheelsPerAxle(int index, int value) {
        this.checkNotNull();
        Raw.setNbWheelsPerAxle(this.address, index, value);
    }

    public int getAxleToWheelIds(int index) {
        this.checkNotNull();
        return Raw.getAxleToWheelIds(this.address, index);
    }

    public void setAxleToWheelIds(int index, int value) {
        this.checkNotNull();
        Raw.setAxleToWheelIds(this.address, index, value);
    }

    public int getWheelIdsInAxleOrder(int index) {
        this.checkNotNull();
        return Raw.getWheelIdsInAxleOrder(this.address, index);
    }

    public void setWheelIdsInAxleOrder(int index, int value) {
        this.checkNotNull();
        Raw.setWheelIdsInAxleOrder(this.address, index, value);
    }

    public int getNbWheels() {
        this.checkNotNull();
        return Raw.getNbWheels(this.address);
    }

    public void setNbWheels(int value) {
        this.checkNotNull();
        Raw.setNbWheels(this.address, value);
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public int getNbWheelsOnAxle(int i) {
        this.checkNotNull();
        return Raw.getNbWheelsOnAxle(this.address, i);
    }

    public int getWheelOnAxle(int j, int i) {
        this.checkNotNull();
        return Raw.getWheelOnAxle(this.address, j, i);
    }

    public int getAxle(int wheelId) {
        this.checkNotNull();
        return Raw.getAxle(this.address, wheelId);
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native long PxVehicleAxleDescription();

        public static native void destroy(long var0);

        public static native int getNbAxles(long var0);

        public static native void setNbAxles(long var0, int var2);

        public static native int getNbWheelsPerAxle(long var0, int var2);

        public static native void setNbWheelsPerAxle(long var0, int var2, int var3);

        public static native int getAxleToWheelIds(long var0, int var2);

        public static native void setAxleToWheelIds(long var0, int var2, int var3);

        public static native int getWheelIdsInAxleOrder(long var0, int var2);

        public static native void setWheelIdsInAxleOrder(long var0, int var2, int var3);

        public static native int getNbWheels(long var0);

        public static native void setNbWheels(long var0, int var2);

        public static native void setToDefault(long var0);

        public static native int getNbWheelsOnAxle(long var0, int var2);

        public static native int getWheelOnAxle(long var0, int var2, int var3);

        public static native int getAxle(long var0, int var2);

        public static native boolean isValid(long var0);
    }
}

