/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.vehicle2.PxVehicleAxleDescription;
import physx.vehicle2.PxVehicleFrame;
import physx.vehicle2.PxVehicleScale;

public class PxVehicleAckermannParams
extends NativeObject {
    public static final int SIZEOF = PxVehicleAckermannParams.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVehicleAckermannParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleAckermannParams(address) : null;
    }

    public static PxVehicleAckermannParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVehicleAckermannParams.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVehicleAckermannParams(long address) {
        super(address);
    }

    public PxVehicleAckermannParams() {
        this.address = Raw.PxVehicleAckermannParams();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getWheelIds(int index) {
        this.checkNotNull();
        return Raw.getWheelIds(this.address, index);
    }

    public void setWheelIds(int index, int value) {
        this.checkNotNull();
        Raw.setWheelIds(this.address, index, value);
    }

    public float getWheelBase() {
        this.checkNotNull();
        return Raw.getWheelBase(this.address);
    }

    public void setWheelBase(float value) {
        this.checkNotNull();
        Raw.setWheelBase(this.address, value);
    }

    public float getTrackWidth() {
        this.checkNotNull();
        return Raw.getTrackWidth(this.address);
    }

    public void setTrackWidth(float value) {
        this.checkNotNull();
        Raw.setTrackWidth(this.address, value);
    }

    public float getStrength() {
        this.checkNotNull();
        return Raw.getStrength(this.address);
    }

    public void setStrength(float value) {
        this.checkNotNull();
        Raw.setStrength(this.address, value);
    }

    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        this.checkNotNull();
        return Raw.isValid(this.address, axleDesc.getAddress());
    }

    public PxVehicleAckermannParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        this.checkNotNull();
        return PxVehicleAckermannParams.wrapPointer(Raw.transformAndScale(this.address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }

    public static class Raw {
        public static native long PxVehicleAckermannParams();

        public static native void destroy(long var0);

        public static native int getWheelIds(long var0, int var2);

        public static native void setWheelIds(long var0, int var2, int var3);

        public static native float getWheelBase(long var0);

        public static native void setWheelBase(long var0, float var2);

        public static native float getTrackWidth(long var0);

        public static native void setTrackWidth(long var0, float var2);

        public static native float getStrength(long var0);

        public static native void setStrength(long var0, float var2);

        public static native boolean isValid(long var0, long var2);

        public static native long transformAndScale(long var0, long var2, long var4, long var6, long var8);
    }
}

