/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.cooking.PxCookingParams;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;
import physx.vehicle2.BaseVehicleParams;
import physx.vehicle2.PhysXIntegrationParams;
import physx.vehicle2.PxVehiclePhysXActor;
import physx.vehicle2.PxVehiclePhysXConstraints;
import physx.vehicle2.PxVehiclePhysXSteerState;

public class PhysXIntegrationState
extends NativeObject {
    public static final int SIZEOF = PhysXIntegrationState.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PhysXIntegrationState wrapPointer(long address) {
        return address != 0L ? new PhysXIntegrationState(address) : null;
    }

    public static PhysXIntegrationState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PhysXIntegrationState.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PhysXIntegrationState(long address) {
        super(address);
    }

    public PhysXIntegrationState() {
        this.address = Raw.PhysXIntegrationState();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVehiclePhysXActor getPhysxActor() {
        this.checkNotNull();
        return PxVehiclePhysXActor.wrapPointer(Raw.getPhysxActor(this.address));
    }

    public void setPhysxActor(PxVehiclePhysXActor value) {
        this.checkNotNull();
        Raw.setPhysxActor(this.address, value.getAddress());
    }

    public PxVehiclePhysXSteerState getPhysxSteerState() {
        this.checkNotNull();
        return PxVehiclePhysXSteerState.wrapPointer(Raw.getPhysxSteerState(this.address));
    }

    public void setPhysxSteerState(PxVehiclePhysXSteerState value) {
        this.checkNotNull();
        Raw.setPhysxSteerState(this.address, value.getAddress());
    }

    public PxVehiclePhysXConstraints getPhysxConstraints() {
        this.checkNotNull();
        return PxVehiclePhysXConstraints.wrapPointer(Raw.getPhysxConstraints(this.address));
    }

    public void setPhysxConstraints(PxVehiclePhysXConstraints value) {
        this.checkNotNull();
        Raw.setPhysxConstraints(this.address, value.getAddress());
    }

    public void destroyState() {
        this.checkNotNull();
        Raw.destroyState(this.address);
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public void create(BaseVehicleParams baseParams, PhysXIntegrationParams physxParams, PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial) {
        this.checkNotNull();
        Raw.create(this.address, baseParams.getAddress(), physxParams.getAddress(), physics.getAddress(), params.getAddress(), defaultMaterial.getAddress());
    }

    public static class Raw {
        public static native long PhysXIntegrationState();

        public static native void destroy(long var0);

        public static native long getPhysxActor(long var0);

        public static native void setPhysxActor(long var0, long var2);

        public static native long getPhysxSteerState(long var0);

        public static native void setPhysxSteerState(long var0, long var2);

        public static native long getPhysxConstraints(long var0);

        public static native void setPhysxConstraints(long var0, long var2);

        public static native void destroyState(long var0);

        public static native void setToDefault(long var0);

        public static native void create(long var0, long var2, long var4, long var6, long var8, long var10);
    }
}

