/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.geometry.PxGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxQueryFilterCallback;
import physx.physics.PxQueryFilterData;
import physx.physics.PxShapeFlags;
import physx.vehicle2.PxVehicleAxleDescription;
import physx.vehicle2.PxVehicleFrame;
import physx.vehicle2.PxVehiclePhysXMaterialFriction;
import physx.vehicle2.PxVehiclePhysXMaterialFrictionParams;
import physx.vehicle2.PxVehiclePhysXRoadGeometryQueryParams;
import physx.vehicle2.PxVehiclePhysXRoadGeometryQueryTypeEnum;
import physx.vehicle2.PxVehiclePhysXSuspensionLimitConstraintParams;
import physx.vehicle2.PxVehicleScale;

public class PhysXIntegrationParams
extends NativeObject {
    public static final int SIZEOF = PhysXIntegrationParams.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PhysXIntegrationParams wrapPointer(long address) {
        return address != 0L ? new PhysXIntegrationParams(address) : null;
    }

    public static PhysXIntegrationParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PhysXIntegrationParams.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PhysXIntegrationParams(long address) {
        super(address);
    }

    public PhysXIntegrationParams() {
        this.address = Raw.PhysXIntegrationParams();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVehiclePhysXRoadGeometryQueryParams getPhysxRoadGeometryQueryParams() {
        this.checkNotNull();
        return PxVehiclePhysXRoadGeometryQueryParams.wrapPointer(Raw.getPhysxRoadGeometryQueryParams(this.address));
    }

    public void setPhysxRoadGeometryQueryParams(PxVehiclePhysXRoadGeometryQueryParams value) {
        this.checkNotNull();
        Raw.setPhysxRoadGeometryQueryParams(this.address, value.getAddress());
    }

    public PxVehiclePhysXMaterialFrictionParams getPhysxMaterialFrictionParams(int index) {
        this.checkNotNull();
        return PxVehiclePhysXMaterialFrictionParams.wrapPointer(Raw.getPhysxMaterialFrictionParams(this.address, index));
    }

    public void setPhysxMaterialFrictionParams(int index, PxVehiclePhysXMaterialFrictionParams value) {
        this.checkNotNull();
        Raw.setPhysxMaterialFrictionParams(this.address, index, value.getAddress());
    }

    public PxVehiclePhysXSuspensionLimitConstraintParams getPhysxSuspensionLimitConstraintParams(int index) {
        this.checkNotNull();
        return PxVehiclePhysXSuspensionLimitConstraintParams.wrapPointer(Raw.getPhysxSuspensionLimitConstraintParams(this.address, index));
    }

    public void setPhysxSuspensionLimitConstraintParams(int index, PxVehiclePhysXSuspensionLimitConstraintParams value) {
        this.checkNotNull();
        Raw.setPhysxSuspensionLimitConstraintParams(this.address, index, value.getAddress());
    }

    public PxTransform getPhysxActorCMassLocalPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getPhysxActorCMassLocalPose(this.address));
    }

    public void setPhysxActorCMassLocalPose(PxTransform value) {
        this.checkNotNull();
        Raw.setPhysxActorCMassLocalPose(this.address, value.getAddress());
    }

    public PxGeometry getPhysxActorGeometry() {
        this.checkNotNull();
        return PxGeometry.wrapPointer(Raw.getPhysxActorGeometry(this.address));
    }

    public void setPhysxActorGeometry(PxGeometry value) {
        this.checkNotNull();
        Raw.setPhysxActorGeometry(this.address, value.getAddress());
    }

    public PxTransform getPhysxActorBoxShapeLocalPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getPhysxActorBoxShapeLocalPose(this.address));
    }

    public void setPhysxActorBoxShapeLocalPose(PxTransform value) {
        this.checkNotNull();
        Raw.setPhysxActorBoxShapeLocalPose(this.address, value.getAddress());
    }

    public PxTransform getPhysxWheelShapeLocalPoses(int index) {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getPhysxWheelShapeLocalPoses(this.address, index));
    }

    public void setPhysxWheelShapeLocalPoses(int index, PxTransform value) {
        this.checkNotNull();
        Raw.setPhysxWheelShapeLocalPoses(this.address, index, value.getAddress());
    }

    public PxShapeFlags getPhysxActorShapeFlags() {
        this.checkNotNull();
        return PxShapeFlags.wrapPointer(Raw.getPhysxActorShapeFlags(this.address));
    }

    public void setPhysxActorShapeFlags(PxShapeFlags value) {
        this.checkNotNull();
        Raw.setPhysxActorShapeFlags(this.address, value.getAddress());
    }

    public PxFilterData getPhysxActorSimulationFilterData() {
        this.checkNotNull();
        return PxFilterData.wrapPointer(Raw.getPhysxActorSimulationFilterData(this.address));
    }

    public void setPhysxActorSimulationFilterData(PxFilterData value) {
        this.checkNotNull();
        Raw.setPhysxActorSimulationFilterData(this.address, value.getAddress());
    }

    public PxFilterData getPhysxActorQueryFilterData() {
        this.checkNotNull();
        return PxFilterData.wrapPointer(Raw.getPhysxActorQueryFilterData(this.address));
    }

    public void setPhysxActorQueryFilterData(PxFilterData value) {
        this.checkNotNull();
        Raw.setPhysxActorQueryFilterData(this.address, value.getAddress());
    }

    public PxShapeFlags getPhysxActorWheelShapeFlags() {
        this.checkNotNull();
        return PxShapeFlags.wrapPointer(Raw.getPhysxActorWheelShapeFlags(this.address));
    }

    public void setPhysxActorWheelShapeFlags(PxShapeFlags value) {
        this.checkNotNull();
        Raw.setPhysxActorWheelShapeFlags(this.address, value.getAddress());
    }

    public PxFilterData getPhysxActorWheelSimulationFilterData() {
        this.checkNotNull();
        return PxFilterData.wrapPointer(Raw.getPhysxActorWheelSimulationFilterData(this.address));
    }

    public void setPhysxActorWheelSimulationFilterData(PxFilterData value) {
        this.checkNotNull();
        Raw.setPhysxActorWheelSimulationFilterData(this.address, value.getAddress());
    }

    public PxFilterData getPhysxActorWheelQueryFilterData() {
        this.checkNotNull();
        return PxFilterData.wrapPointer(Raw.getPhysxActorWheelQueryFilterData(this.address));
    }

    public void setPhysxActorWheelQueryFilterData(PxFilterData value) {
        this.checkNotNull();
        Raw.setPhysxActorWheelQueryFilterData(this.address, value.getAddress());
    }

    public PhysXIntegrationParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        this.checkNotNull();
        return PhysXIntegrationParams.wrapPointer(Raw.transformAndScale(this.address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }

    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        this.checkNotNull();
        return Raw.isValid(this.address, axleDesc.getAddress());
    }

    public void create(PxVehicleAxleDescription axleDesc, PxQueryFilterData roadQueryFilterData, PxQueryFilterCallback roadQueryFilterCallback, PxVehiclePhysXMaterialFriction materialFrictions, int nbMaterialFrictions, float defaultFriction, PxTransform physxActorCMassLocalPose, PxGeometry actorGeometry, PxTransform physxActorBoxShapeLocalPose, PxVehiclePhysXRoadGeometryQueryTypeEnum roadGeometryQueryType) {
        this.checkNotNull();
        Raw.create(this.address, axleDesc.getAddress(), roadQueryFilterData.getAddress(), roadQueryFilterCallback != null ? roadQueryFilterCallback.getAddress() : 0L, materialFrictions.getAddress(), nbMaterialFrictions, defaultFriction, physxActorCMassLocalPose.getAddress(), actorGeometry.getAddress(), physxActorBoxShapeLocalPose.getAddress(), roadGeometryQueryType.value);
    }

    public static class Raw {
        public static native long PhysXIntegrationParams();

        public static native void destroy(long var0);

        public static native long getPhysxRoadGeometryQueryParams(long var0);

        public static native void setPhysxRoadGeometryQueryParams(long var0, long var2);

        public static native long getPhysxMaterialFrictionParams(long var0, int var2);

        public static native void setPhysxMaterialFrictionParams(long var0, int var2, long var3);

        public static native long getPhysxSuspensionLimitConstraintParams(long var0, int var2);

        public static native void setPhysxSuspensionLimitConstraintParams(long var0, int var2, long var3);

        public static native long getPhysxActorCMassLocalPose(long var0);

        public static native void setPhysxActorCMassLocalPose(long var0, long var2);

        public static native long getPhysxActorGeometry(long var0);

        public static native void setPhysxActorGeometry(long var0, long var2);

        public static native long getPhysxActorBoxShapeLocalPose(long var0);

        public static native void setPhysxActorBoxShapeLocalPose(long var0, long var2);

        public static native long getPhysxWheelShapeLocalPoses(long var0, int var2);

        public static native void setPhysxWheelShapeLocalPoses(long var0, int var2, long var3);

        public static native long getPhysxActorShapeFlags(long var0);

        public static native void setPhysxActorShapeFlags(long var0, long var2);

        public static native long getPhysxActorSimulationFilterData(long var0);

        public static native void setPhysxActorSimulationFilterData(long var0, long var2);

        public static native long getPhysxActorQueryFilterData(long var0);

        public static native void setPhysxActorQueryFilterData(long var0, long var2);

        public static native long getPhysxActorWheelShapeFlags(long var0);

        public static native void setPhysxActorWheelShapeFlags(long var0, long var2);

        public static native long getPhysxActorWheelSimulationFilterData(long var0);

        public static native void setPhysxActorWheelSimulationFilterData(long var0, long var2);

        public static native long getPhysxActorWheelQueryFilterData(long var0);

        public static native void setPhysxActorWheelQueryFilterData(long var0, long var2);

        public static native long transformAndScale(long var0, long var2, long var4, long var6, long var8);

        public static native boolean isValid(long var0, long var2);

        public static native void create(long var0, long var2, long var4, long var6, long var8, int var10, float var11, long var12, long var14, long var16, int var18);
    }
}

