/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;
import physx.physics.PxArticulationReducedCoordinate;
import physx.physics.PxRigidActor;
import physx.physics.PxScene;
import physx.physics.PxShape;
import physx.support.PxArray_PxActorPtr;

public class SupportFunctions
extends NativeObject {
    public static final int SIZEOF = SupportFunctions.__sizeOf();
    public static final int ALIGNOF = 8;

    protected SupportFunctions() {
    }

    private static native int __sizeOf();

    public static SupportFunctions wrapPointer(long address) {
        return address != 0L ? new SupportFunctions(address) : null;
    }

    public static SupportFunctions arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return SupportFunctions.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected SupportFunctions(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static PxShape PxActor_getShape(PxRigidActor actor, int index) {
        return PxShape.wrapPointer(Raw.PxActor_getShape(actor.getAddress(), index));
    }

    public static PxArray_PxActorPtr PxScene_getActiveActors(PxScene scene) {
        return PxArray_PxActorPtr.wrapPointer(Raw.PxScene_getActiveActors(scene.getAddress()));
    }

    public static int PxArticulationReducedCoordinate_getMinSolverPositionIterations(PxArticulationReducedCoordinate articulation) {
        return Raw.PxArticulationReducedCoordinate_getMinSolverPositionIterations(articulation.getAddress());
    }

    public static int PxArticulationReducedCoordinate_getMinSolverVelocityIterations(PxArticulationReducedCoordinate articulation) {
        return Raw.PxArticulationReducedCoordinate_getMinSolverVelocityIterations(articulation.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long PxActor_getShape(long var0, int var2);

        public static native long PxScene_getActiveActors(long var0);

        public static native int PxArticulationReducedCoordinate_getMinSolverPositionIterations(long var0);

        public static native int PxArticulationReducedCoordinate_getMinSolverVelocityIterations(long var0);
    }
}

