/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.support.PxU32ConstPtr;

public class PxU32Ptr
extends PxU32ConstPtr {
    public static final int SIZEOF = PxU32Ptr.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxU32Ptr() {
    }

    private static native int __sizeOf();

    public static PxU32Ptr wrapPointer(long address) {
        return address != 0L ? new PxU32Ptr(address) : null;
    }

    public static PxU32Ptr arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxU32Ptr.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxU32Ptr(long address) {
        super(address);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static class Raw {
        public static native void destroy(long var0);
    }
}

