/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;

public class PxArray_PxU8
extends NativeObject {
    public static final int SIZEOF = PxArray_PxU8.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxArray_PxU8 wrapPointer(long address) {
        return address != 0L ? new PxArray_PxU8(address) : null;
    }

    public static PxArray_PxU8 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxArray_PxU8.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxArray_PxU8(long address) {
        super(address);
    }

    public static PxArray_PxU8 createAt(long address) {
        Raw.PxArray_PxU8_placed(address);
        PxArray_PxU8 createdObj = PxArray_PxU8.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxU8 createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxU8_placed(address);
        PxArray_PxU8 createdObj = PxArray_PxU8.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxArray_PxU8 createAt(long address, int size) {
        Raw.PxArray_PxU8_placed(address, size);
        PxArray_PxU8 createdObj = PxArray_PxU8.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxU8 createAt(T allocator, NativeObject.Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxU8_placed(address, size);
        PxArray_PxU8 createdObj = PxArray_PxU8.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxArray_PxU8() {
        this.address = Raw.PxArray_PxU8();
    }

    public PxArray_PxU8(int size) {
        this.address = Raw.PxArray_PxU8(size);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public byte get(int index) {
        this.checkNotNull();
        return Raw.get(this.address, index);
    }

    public void set(int index, byte value) {
        this.checkNotNull();
        Raw.set(this.address, index, value);
    }

    public NativeObject begin() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.begin(this.address));
    }

    public int size() {
        this.checkNotNull();
        return Raw.size(this.address);
    }

    public void pushBack(byte value) {
        this.checkNotNull();
        Raw.pushBack(this.address, value);
    }

    public void setFromBuffer(NativeObject buffer, int size) {
        this.checkNotNull();
        Raw.setFromBuffer(this.address, buffer.getAddress(), size);
    }

    public void clear() {
        this.checkNotNull();
        Raw.clear(this.address);
    }

    public static class Raw {
        public static native void PxArray_PxU8_placed(long var0);

        public static native void PxArray_PxU8_placed(long var0, int var2);

        public static native long PxArray_PxU8();

        public static native long PxArray_PxU8(int var0);

        public static native void destroy(long var0);

        public static native byte get(long var0, int var2);

        public static native void set(long var0, int var2, byte var3);

        public static native long begin(long var0);

        public static native int size(long var0);

        public static native void pushBack(long var0, byte var2);

        public static native void setFromBuffer(long var0, long var2, int var4);

        public static native void clear(long var0);
    }
}

