/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;
import physx.physics.PxShape;
import physx.support.PxShapePtr;

public class PxArray_PxShapePtr
extends NativeObject {
    public static final int SIZEOF = PxArray_PxShapePtr.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxArray_PxShapePtr wrapPointer(long address) {
        return address != 0L ? new PxArray_PxShapePtr(address) : null;
    }

    public static PxArray_PxShapePtr arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxArray_PxShapePtr.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxArray_PxShapePtr(long address) {
        super(address);
    }

    public static PxArray_PxShapePtr createAt(long address) {
        Raw.PxArray_PxShapePtr_placed(address);
        PxArray_PxShapePtr createdObj = PxArray_PxShapePtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxShapePtr createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxShapePtr_placed(address);
        PxArray_PxShapePtr createdObj = PxArray_PxShapePtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxArray_PxShapePtr createAt(long address, int size) {
        Raw.PxArray_PxShapePtr_placed(address, size);
        PxArray_PxShapePtr createdObj = PxArray_PxShapePtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxShapePtr createAt(T allocator, NativeObject.Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxShapePtr_placed(address, size);
        PxArray_PxShapePtr createdObj = PxArray_PxShapePtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxArray_PxShapePtr() {
        this.address = Raw.PxArray_PxShapePtr();
    }

    public PxArray_PxShapePtr(int size) {
        this.address = Raw.PxArray_PxShapePtr(size);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxShape get(int index) {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.get(this.address, index));
    }

    public void set(int index, PxShapePtr value) {
        this.checkNotNull();
        Raw.set(this.address, index, value.getAddress());
    }

    public PxShapePtr begin() {
        this.checkNotNull();
        return PxShapePtr.wrapPointer(Raw.begin(this.address));
    }

    public int size() {
        this.checkNotNull();
        return Raw.size(this.address);
    }

    public void pushBack(PxShape value) {
        this.checkNotNull();
        Raw.pushBack(this.address, value.getAddress());
    }

    public void clear() {
        this.checkNotNull();
        Raw.clear(this.address);
    }

    public static class Raw {
        public static native void PxArray_PxShapePtr_placed(long var0);

        public static native void PxArray_PxShapePtr_placed(long var0, int var2);

        public static native long PxArray_PxShapePtr();

        public static native long PxArray_PxShapePtr(int var0);

        public static native void destroy(long var0);

        public static native long get(long var0, int var2);

        public static native void set(long var0, int var2, long var3);

        public static native long begin(long var0);

        public static native int size(long var0);

        public static native void pushBack(long var0, long var2);

        public static native void clear(long var0);
    }
}

