/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;
import physx.physics.PxActor;
import physx.support.PxActorPtr;

public class PxArray_PxActorPtr
extends NativeObject {
    public static final int SIZEOF = PxArray_PxActorPtr.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxArray_PxActorPtr wrapPointer(long address) {
        return address != 0L ? new PxArray_PxActorPtr(address) : null;
    }

    public static PxArray_PxActorPtr arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxArray_PxActorPtr.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxArray_PxActorPtr(long address) {
        super(address);
    }

    public static PxArray_PxActorPtr createAt(long address) {
        Raw.PxArray_PxActorPtr_placed(address);
        PxArray_PxActorPtr createdObj = PxArray_PxActorPtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxActorPtr createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxActorPtr_placed(address);
        PxArray_PxActorPtr createdObj = PxArray_PxActorPtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxArray_PxActorPtr createAt(long address, int size) {
        Raw.PxArray_PxActorPtr_placed(address, size);
        PxArray_PxActorPtr createdObj = PxArray_PxActorPtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxActorPtr createAt(T allocator, NativeObject.Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxActorPtr_placed(address, size);
        PxArray_PxActorPtr createdObj = PxArray_PxActorPtr.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxArray_PxActorPtr() {
        this.address = Raw.PxArray_PxActorPtr();
    }

    public PxArray_PxActorPtr(int size) {
        this.address = Raw.PxArray_PxActorPtr(size);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxActor get(int index) {
        this.checkNotNull();
        return PxActor.wrapPointer(Raw.get(this.address, index));
    }

    public void set(int index, PxActorPtr value) {
        this.checkNotNull();
        Raw.set(this.address, index, value.getAddress());
    }

    public PxActorPtr begin() {
        this.checkNotNull();
        return PxActorPtr.wrapPointer(Raw.begin(this.address));
    }

    public int size() {
        this.checkNotNull();
        return Raw.size(this.address);
    }

    public void pushBack(PxActor value) {
        this.checkNotNull();
        Raw.pushBack(this.address, value.getAddress());
    }

    public void clear() {
        this.checkNotNull();
        Raw.clear(this.address);
    }

    public static class Raw {
        public static native void PxArray_PxActorPtr_placed(long var0);

        public static native void PxArray_PxActorPtr_placed(long var0, int var2);

        public static native long PxArray_PxActorPtr();

        public static native long PxArray_PxActorPtr(int var0);

        public static native void destroy(long var0);

        public static native long get(long var0, int var2);

        public static native void set(long var0, int var2, long var3);

        public static native long begin(long var0);

        public static native int size(long var0);

        public static native void pushBack(long var0, long var2);

        public static native void clear(long var0);
    }
}

