/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.physics.PxActor;
import physx.physics.PxPairFlagEnum;
import physx.physics.PxShape;
import physx.physics.PxTriggerPairFlags;

public class PxTriggerPair
extends NativeObject {
    public static final int SIZEOF = PxTriggerPair.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxTriggerPair() {
    }

    private static native int __sizeOf();

    public static PxTriggerPair wrapPointer(long address) {
        return address != 0L ? new PxTriggerPair(address) : null;
    }

    public static PxTriggerPair arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxTriggerPair.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxTriggerPair(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxShape getTriggerShape() {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.getTriggerShape(this.address));
    }

    public void setTriggerShape(PxShape value) {
        this.checkNotNull();
        Raw.setTriggerShape(this.address, value.getAddress());
    }

    public PxActor getTriggerActor() {
        this.checkNotNull();
        return PxActor.wrapPointer(Raw.getTriggerActor(this.address));
    }

    public void setTriggerActor(PxActor value) {
        this.checkNotNull();
        Raw.setTriggerActor(this.address, value.getAddress());
    }

    @Deprecated
    public PxShape getOtherShape() {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.getOtherShape(this.address));
    }

    @Deprecated
    public void setOtherShape(PxShape value) {
        this.checkNotNull();
        Raw.setOtherShape(this.address, value.getAddress());
    }

    public PxActor getOtherActor() {
        this.checkNotNull();
        return PxActor.wrapPointer(Raw.getOtherActor(this.address));
    }

    public void setOtherActor(PxActor value) {
        this.checkNotNull();
        Raw.setOtherActor(this.address, value.getAddress());
    }

    public PxPairFlagEnum getStatus() {
        this.checkNotNull();
        return PxPairFlagEnum.forValue(Raw.getStatus(this.address));
    }

    public void setStatus(PxPairFlagEnum value) {
        this.checkNotNull();
        Raw.setStatus(this.address, value.value);
    }

    public PxTriggerPairFlags getFlags() {
        this.checkNotNull();
        return PxTriggerPairFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxTriggerPairFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getTriggerShape(long var0);

        public static native void setTriggerShape(long var0, long var2);

        public static native long getTriggerActor(long var0);

        public static native void setTriggerActor(long var0, long var2);

        public static native long getOtherShape(long var0);

        public static native void setOtherShape(long var0, long var2);

        public static native long getOtherActor(long var0);

        public static native void setOtherActor(long var0, long var2);

        public static native int getStatus(long var0);

        public static native void setStatus(long var0, int var2);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);
    }
}

