/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.physics.PxSweepCallback;
import physx.physics.PxSweepHit;

public class PxSweepResult
extends PxSweepCallback {
    public static final int SIZEOF = PxSweepResult.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxSweepResult wrapPointer(long address) {
        return address != 0L ? new PxSweepResult(address) : null;
    }

    public static PxSweepResult arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSweepResult.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSweepResult(long address) {
        super(address);
    }

    public PxSweepResult() {
        this.address = Raw.PxSweepResult();
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxSweepHit getBlock() {
        this.checkNotNull();
        return PxSweepHit.wrapPointer(Raw.getBlock(this.address));
    }

    public void setBlock(PxSweepHit value) {
        this.checkNotNull();
        Raw.setBlock(this.address, value.getAddress());
    }

    public boolean getHasBlock() {
        this.checkNotNull();
        return Raw.getHasBlock(this.address);
    }

    public void setHasBlock(boolean value) {
        this.checkNotNull();
        Raw.setHasBlock(this.address, value);
    }

    public int getNbAnyHits() {
        this.checkNotNull();
        return Raw.getNbAnyHits(this.address);
    }

    public PxSweepHit getAnyHit(int index) {
        this.checkNotNull();
        return PxSweepHit.wrapPointer(Raw.getAnyHit(this.address, index));
    }

    public int getNbTouches() {
        this.checkNotNull();
        return Raw.getNbTouches(this.address);
    }

    public PxSweepHit getTouch(int index) {
        this.checkNotNull();
        return PxSweepHit.wrapPointer(Raw.getTouch(this.address, index));
    }

    public static class Raw {
        public static native long PxSweepResult();

        public static native void destroy(long var0);

        public static native long getBlock(long var0);

        public static native void setBlock(long var0, long var2);

        public static native boolean getHasBlock(long var0);

        public static native void setHasBlock(long var0, boolean var2);

        public static native int getNbAnyHits(long var0);

        public static native long getAnyHit(long var0, int var2);

        public static native int getNbTouches(long var0);

        public static native long getTouch(long var0, int var2);
    }
}

