/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.physics.PxSweepCallback;
import physx.physics.PxSweepHit;

public class PxSweepBuffer10
extends PxSweepCallback {
    public static final int SIZEOF = PxSweepBuffer10.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxSweepBuffer10 wrapPointer(long address) {
        return address != 0L ? new PxSweepBuffer10(address) : null;
    }

    public static PxSweepBuffer10 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSweepBuffer10.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSweepBuffer10(long address) {
        super(address);
    }

    public PxSweepBuffer10() {
        this.address = Raw.PxSweepBuffer10();
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxSweepHit getBlock() {
        this.checkNotNull();
        return PxSweepHit.wrapPointer(Raw.getBlock(this.address));
    }

    public void setBlock(PxSweepHit value) {
        this.checkNotNull();
        Raw.setBlock(this.address, value.getAddress());
    }

    public boolean getHasBlock() {
        this.checkNotNull();
        return Raw.getHasBlock(this.address);
    }

    public void setHasBlock(boolean value) {
        this.checkNotNull();
        Raw.setHasBlock(this.address, value);
    }

    public int getNbAnyHits() {
        this.checkNotNull();
        return Raw.getNbAnyHits(this.address);
    }

    public PxSweepHit getAnyHit(int index) {
        this.checkNotNull();
        return PxSweepHit.wrapPointer(Raw.getAnyHit(this.address, index));
    }

    public int getNbTouches() {
        this.checkNotNull();
        return Raw.getNbTouches(this.address);
    }

    public PxSweepHit getTouches() {
        this.checkNotNull();
        return PxSweepHit.wrapPointer(Raw.getTouches(this.address));
    }

    public PxSweepHit getTouch(int index) {
        this.checkNotNull();
        return PxSweepHit.wrapPointer(Raw.getTouch(this.address, index));
    }

    public int getMaxNbTouches() {
        this.checkNotNull();
        return Raw.getMaxNbTouches(this.address);
    }

    public static class Raw {
        public static native long PxSweepBuffer10();

        public static native void destroy(long var0);

        public static native long getBlock(long var0);

        public static native void setBlock(long var0, long var2);

        public static native boolean getHasBlock(long var0);

        public static native void setHasBlock(long var0, boolean var2);

        public static native int getNbAnyHits(long var0);

        public static native long getAnyHit(long var0, int var2);

        public static native int getNbTouches(long var0);

        public static native long getTouches(long var0);

        public static native long getTouch(long var0, int var2);

        public static native int getMaxNbTouches(long var0);
    }
}

