/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxGeometry;
import physx.physics.PxHitFlags;
import physx.physics.PxOverlapCallback;
import physx.physics.PxQueryFilterData;
import physx.physics.PxRaycastCallback;
import physx.physics.PxSceneQueryUpdateModeEnum;
import physx.physics.PxSweepCallback;

public class PxSceneQuerySystemBase
extends NativeObject {
    public static final int SIZEOF = PxSceneQuerySystemBase.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxSceneQuerySystemBase() {
    }

    private static native int __sizeOf();

    public static PxSceneQuerySystemBase wrapPointer(long address) {
        return address != 0L ? new PxSceneQuerySystemBase(address) : null;
    }

    public static PxSceneQuerySystemBase arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSceneQuerySystemBase.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSceneQuerySystemBase(long address) {
        super(address);
    }

    public void setDynamicTreeRebuildRateHint(int dynamicTreeRebuildRateHint) {
        this.checkNotNull();
        Raw.setDynamicTreeRebuildRateHint(this.address, dynamicTreeRebuildRateHint);
    }

    public int getDynamicTreeRebuildRateHint() {
        this.checkNotNull();
        return Raw.getDynamicTreeRebuildRateHint(this.address);
    }

    public void forceRebuildDynamicTree(int prunerIndex) {
        this.checkNotNull();
        Raw.forceRebuildDynamicTree(this.address, prunerIndex);
    }

    public void setUpdateMode(PxSceneQueryUpdateModeEnum updateMode) {
        this.checkNotNull();
        Raw.setUpdateMode(this.address, updateMode.value);
    }

    public PxSceneQueryUpdateModeEnum getUpdateMode() {
        this.checkNotNull();
        return PxSceneQueryUpdateModeEnum.forValue(Raw.getUpdateMode(this.address));
    }

    public int getStaticTimestamp() {
        this.checkNotNull();
        return Raw.getStaticTimestamp(this.address);
    }

    public void flushUpdates() {
        this.checkNotNull();
        Raw.flushUpdates(this.address);
    }

    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall) {
        this.checkNotNull();
        return Raw.raycast(this.address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress());
    }

    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall, PxHitFlags hitFlags) {
        this.checkNotNull();
        return Raw.raycast(this.address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress());
    }

    public boolean raycast(PxVec3 origin, PxVec3 unitDir, float distance, PxRaycastCallback hitCall, PxHitFlags hitFlags, PxQueryFilterData filterData) {
        this.checkNotNull();
        return Raw.raycast(this.address, origin.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress(), filterData.getAddress());
    }

    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall) {
        this.checkNotNull();
        return Raw.sweep(this.address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress());
    }

    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall, PxHitFlags hitFlags) {
        this.checkNotNull();
        return Raw.sweep(this.address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress());
    }

    public boolean sweep(PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxSweepCallback hitCall, PxHitFlags hitFlags, PxQueryFilterData filterData) {
        this.checkNotNull();
        return Raw.sweep(this.address, geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, hitCall.getAddress(), hitFlags.getAddress(), filterData.getAddress());
    }

    public boolean overlap(PxGeometry geometry, PxTransform pose, PxOverlapCallback hitCall) {
        this.checkNotNull();
        return Raw.overlap(this.address, geometry.getAddress(), pose.getAddress(), hitCall.getAddress());
    }

    public boolean overlap(PxGeometry geometry, PxTransform pose, PxOverlapCallback hitCall, PxQueryFilterData filterData) {
        this.checkNotNull();
        return Raw.overlap(this.address, geometry.getAddress(), pose.getAddress(), hitCall.getAddress(), filterData.getAddress());
    }

    public static class Raw {
        public static native void setDynamicTreeRebuildRateHint(long var0, int var2);

        public static native int getDynamicTreeRebuildRateHint(long var0);

        public static native void forceRebuildDynamicTree(long var0, int var2);

        public static native void setUpdateMode(long var0, int var2);

        public static native int getUpdateMode(long var0);

        public static native int getStaticTimestamp(long var0);

        public static native void flushUpdates(long var0);

        public static native boolean raycast(long var0, long var2, long var4, float var6, long var7);

        public static native boolean raycast(long var0, long var2, long var4, float var6, long var7, long var9);

        public static native boolean raycast(long var0, long var2, long var4, float var6, long var7, long var9, long var11);

        public static native boolean sweep(long var0, long var2, long var4, long var6, float var8, long var9);

        public static native boolean sweep(long var0, long var2, long var4, long var6, float var8, long var9, long var11);

        public static native boolean sweep(long var0, long var2, long var4, long var6, float var8, long var9, long var11, long var13);

        public static native boolean overlap(long var0, long var2, long var4, long var6);

        public static native boolean overlap(long var0, long var2, long var4, long var6, long var8);
    }
}

