/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.common.PxBounds3;
import physx.common.PxCpuDispatcher;
import physx.common.PxTolerancesScale;
import physx.common.PxVec3;
import physx.physics.PxBVHBuildStrategyEnum;
import physx.physics.PxBroadPhaseTypeEnum;
import physx.physics.PxDynamicTreeSecondaryPrunerEnum;
import physx.physics.PxFrictionTypeEnum;
import physx.physics.PxPairFilteringModeEnum;
import physx.physics.PxPruningStructureTypeEnum;
import physx.physics.PxSceneFlags;
import physx.physics.PxSceneLimits;
import physx.physics.PxSceneQueryUpdateModeEnum;
import physx.physics.PxSimulationEventCallback;
import physx.physics.PxSimulationFilterShader;
import physx.physics.PxSolverTypeEnum;

public class PxSceneDesc
extends NativeObject {
    public static final int SIZEOF = PxSceneDesc.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxSceneDesc() {
    }

    private static native int __sizeOf();

    public static PxSceneDesc wrapPointer(long address) {
        return address != 0L ? new PxSceneDesc(address) : null;
    }

    public static PxSceneDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSceneDesc.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSceneDesc(long address) {
        super(address);
    }

    public static PxSceneDesc createAt(long address, PxTolerancesScale scale) {
        Raw.PxSceneDesc_placed(address, scale.getAddress());
        PxSceneDesc createdObj = PxSceneDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxSceneDesc createAt(T allocator, NativeObject.Allocator<T> allocate, PxTolerancesScale scale) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxSceneDesc_placed(address, scale.getAddress());
        PxSceneDesc createdObj = PxSceneDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxSceneDesc(PxTolerancesScale scale) {
        this.address = Raw.PxSceneDesc(scale.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getGravity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getGravity(this.address));
    }

    public void setGravity(PxVec3 value) {
        this.checkNotNull();
        Raw.setGravity(this.address, value.getAddress());
    }

    public PxSimulationEventCallback getSimulationEventCallback() {
        this.checkNotNull();
        return PxSimulationEventCallback.wrapPointer(Raw.getSimulationEventCallback(this.address));
    }

    public void setSimulationEventCallback(PxSimulationEventCallback value) {
        this.checkNotNull();
        Raw.setSimulationEventCallback(this.address, value.getAddress());
    }

    public NativeObject getFilterShaderData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getFilterShaderData(this.address));
    }

    public void setFilterShaderData(NativeObject value) {
        this.checkNotNull();
        Raw.setFilterShaderData(this.address, value.getAddress());
    }

    public int getFilterShaderDataSize() {
        this.checkNotNull();
        return Raw.getFilterShaderDataSize(this.address);
    }

    public void setFilterShaderDataSize(int value) {
        this.checkNotNull();
        Raw.setFilterShaderDataSize(this.address, value);
    }

    public PxSimulationFilterShader getFilterShader() {
        this.checkNotNull();
        return PxSimulationFilterShader.wrapPointer(Raw.getFilterShader(this.address));
    }

    public void setFilterShader(PxSimulationFilterShader value) {
        this.checkNotNull();
        Raw.setFilterShader(this.address, value.getAddress());
    }

    public PxPairFilteringModeEnum getKineKineFilteringMode() {
        this.checkNotNull();
        return PxPairFilteringModeEnum.forValue(Raw.getKineKineFilteringMode(this.address));
    }

    public void setKineKineFilteringMode(PxPairFilteringModeEnum value) {
        this.checkNotNull();
        Raw.setKineKineFilteringMode(this.address, value.value);
    }

    public PxPairFilteringModeEnum getStaticKineFilteringMode() {
        this.checkNotNull();
        return PxPairFilteringModeEnum.forValue(Raw.getStaticKineFilteringMode(this.address));
    }

    public void setStaticKineFilteringMode(PxPairFilteringModeEnum value) {
        this.checkNotNull();
        Raw.setStaticKineFilteringMode(this.address, value.value);
    }

    public PxBroadPhaseTypeEnum getBroadPhaseType() {
        this.checkNotNull();
        return PxBroadPhaseTypeEnum.forValue(Raw.getBroadPhaseType(this.address));
    }

    public void setBroadPhaseType(PxBroadPhaseTypeEnum value) {
        this.checkNotNull();
        Raw.setBroadPhaseType(this.address, value.value);
    }

    public PxSceneLimits getLimits() {
        this.checkNotNull();
        return PxSceneLimits.wrapPointer(Raw.getLimits(this.address));
    }

    public void setLimits(PxSceneLimits value) {
        this.checkNotNull();
        Raw.setLimits(this.address, value.getAddress());
    }

    @Deprecated
    public PxFrictionTypeEnum getFrictionType() {
        this.checkNotNull();
        return PxFrictionTypeEnum.forValue(Raw.getFrictionType(this.address));
    }

    @Deprecated
    public void setFrictionType(PxFrictionTypeEnum value) {
        this.checkNotNull();
        Raw.setFrictionType(this.address, value.value);
    }

    public PxSolverTypeEnum getSolverType() {
        this.checkNotNull();
        return PxSolverTypeEnum.forValue(Raw.getSolverType(this.address));
    }

    public void setSolverType(PxSolverTypeEnum value) {
        this.checkNotNull();
        Raw.setSolverType(this.address, value.value);
    }

    public float getBounceThresholdVelocity() {
        this.checkNotNull();
        return Raw.getBounceThresholdVelocity(this.address);
    }

    public void setBounceThresholdVelocity(float value) {
        this.checkNotNull();
        Raw.setBounceThresholdVelocity(this.address, value);
    }

    public float getFrictionOffsetThreshold() {
        this.checkNotNull();
        return Raw.getFrictionOffsetThreshold(this.address);
    }

    public void setFrictionOffsetThreshold(float value) {
        this.checkNotNull();
        Raw.setFrictionOffsetThreshold(this.address, value);
    }

    public float getFrictionCorrelationDistance() {
        this.checkNotNull();
        return Raw.getFrictionCorrelationDistance(this.address);
    }

    public void setFrictionCorrelationDistance(float value) {
        this.checkNotNull();
        Raw.setFrictionCorrelationDistance(this.address, value);
    }

    public PxSceneFlags getFlags() {
        this.checkNotNull();
        return PxSceneFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxSceneFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public PxCpuDispatcher getCpuDispatcher() {
        this.checkNotNull();
        return PxCpuDispatcher.wrapPointer(Raw.getCpuDispatcher(this.address));
    }

    public void setCpuDispatcher(PxCpuDispatcher value) {
        this.checkNotNull();
        Raw.setCpuDispatcher(this.address, value.getAddress());
    }

    public NativeObject getUserData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getUserData(this.address));
    }

    public void setUserData(NativeObject value) {
        this.checkNotNull();
        Raw.setUserData(this.address, value.getAddress());
    }

    public int getSolverBatchSize() {
        this.checkNotNull();
        return Raw.getSolverBatchSize(this.address);
    }

    public void setSolverBatchSize(int value) {
        this.checkNotNull();
        Raw.setSolverBatchSize(this.address, value);
    }

    public int getSolverArticulationBatchSize() {
        this.checkNotNull();
        return Raw.getSolverArticulationBatchSize(this.address);
    }

    public void setSolverArticulationBatchSize(int value) {
        this.checkNotNull();
        Raw.setSolverArticulationBatchSize(this.address, value);
    }

    public int getNbContactDataBlocks() {
        this.checkNotNull();
        return Raw.getNbContactDataBlocks(this.address);
    }

    public void setNbContactDataBlocks(int value) {
        this.checkNotNull();
        Raw.setNbContactDataBlocks(this.address, value);
    }

    public int getMaxNbContactDataBlocks() {
        this.checkNotNull();
        return Raw.getMaxNbContactDataBlocks(this.address);
    }

    public void setMaxNbContactDataBlocks(int value) {
        this.checkNotNull();
        Raw.setMaxNbContactDataBlocks(this.address, value);
    }

    public float getMaxBiasCoefficient() {
        this.checkNotNull();
        return Raw.getMaxBiasCoefficient(this.address);
    }

    public void setMaxBiasCoefficient(float value) {
        this.checkNotNull();
        Raw.setMaxBiasCoefficient(this.address, value);
    }

    public int getContactReportStreamBufferSize() {
        this.checkNotNull();
        return Raw.getContactReportStreamBufferSize(this.address);
    }

    public void setContactReportStreamBufferSize(int value) {
        this.checkNotNull();
        Raw.setContactReportStreamBufferSize(this.address, value);
    }

    public int getCcdMaxPasses() {
        this.checkNotNull();
        return Raw.getCcdMaxPasses(this.address);
    }

    public void setCcdMaxPasses(int value) {
        this.checkNotNull();
        Raw.setCcdMaxPasses(this.address, value);
    }

    public float getCcdThreshold() {
        this.checkNotNull();
        return Raw.getCcdThreshold(this.address);
    }

    public void setCcdThreshold(float value) {
        this.checkNotNull();
        Raw.setCcdThreshold(this.address, value);
    }

    public float getCcdMaxSeparation() {
        this.checkNotNull();
        return Raw.getCcdMaxSeparation(this.address);
    }

    public void setCcdMaxSeparation(float value) {
        this.checkNotNull();
        Raw.setCcdMaxSeparation(this.address, value);
    }

    public float getWakeCounterResetValue() {
        this.checkNotNull();
        return Raw.getWakeCounterResetValue(this.address);
    }

    public void setWakeCounterResetValue(float value) {
        this.checkNotNull();
        Raw.setWakeCounterResetValue(this.address, value);
    }

    public PxBounds3 getSanityBounds() {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getSanityBounds(this.address));
    }

    public void setSanityBounds(PxBounds3 value) {
        this.checkNotNull();
        Raw.setSanityBounds(this.address, value.getAddress());
    }

    public int getGpuMaxNumPartitions() {
        this.checkNotNull();
        return Raw.getGpuMaxNumPartitions(this.address);
    }

    public void setGpuMaxNumPartitions(int value) {
        this.checkNotNull();
        Raw.setGpuMaxNumPartitions(this.address, value);
    }

    public int getGpuMaxNumStaticPartitions() {
        this.checkNotNull();
        return Raw.getGpuMaxNumStaticPartitions(this.address);
    }

    public void setGpuMaxNumStaticPartitions(int value) {
        this.checkNotNull();
        Raw.setGpuMaxNumStaticPartitions(this.address, value);
    }

    public int getGpuComputeVersion() {
        this.checkNotNull();
        return Raw.getGpuComputeVersion(this.address);
    }

    public void setGpuComputeVersion(int value) {
        this.checkNotNull();
        Raw.setGpuComputeVersion(this.address, value);
    }

    public int getContactPairSlabSize() {
        this.checkNotNull();
        return Raw.getContactPairSlabSize(this.address);
    }

    public void setContactPairSlabSize(int value) {
        this.checkNotNull();
        Raw.setContactPairSlabSize(this.address, value);
    }

    public PxPruningStructureTypeEnum getStaticStructure() {
        this.checkNotNull();
        return PxPruningStructureTypeEnum.forValue(Raw.getStaticStructure(this.address));
    }

    public void setStaticStructure(PxPruningStructureTypeEnum value) {
        this.checkNotNull();
        Raw.setStaticStructure(this.address, value.value);
    }

    public PxPruningStructureTypeEnum getDynamicStructure() {
        this.checkNotNull();
        return PxPruningStructureTypeEnum.forValue(Raw.getDynamicStructure(this.address));
    }

    public void setDynamicStructure(PxPruningStructureTypeEnum value) {
        this.checkNotNull();
        Raw.setDynamicStructure(this.address, value.value);
    }

    public int getDynamicTreeRebuildRateHint() {
        this.checkNotNull();
        return Raw.getDynamicTreeRebuildRateHint(this.address);
    }

    public void setDynamicTreeRebuildRateHint(int value) {
        this.checkNotNull();
        Raw.setDynamicTreeRebuildRateHint(this.address, value);
    }

    public PxDynamicTreeSecondaryPrunerEnum getDynamicTreeSecondaryPruner() {
        this.checkNotNull();
        return PxDynamicTreeSecondaryPrunerEnum.forValue(Raw.getDynamicTreeSecondaryPruner(this.address));
    }

    public void setDynamicTreeSecondaryPruner(PxDynamicTreeSecondaryPrunerEnum value) {
        this.checkNotNull();
        Raw.setDynamicTreeSecondaryPruner(this.address, value.value);
    }

    public PxBVHBuildStrategyEnum getStaticBVHBuildStrategy() {
        this.checkNotNull();
        return PxBVHBuildStrategyEnum.forValue(Raw.getStaticBVHBuildStrategy(this.address));
    }

    public void setStaticBVHBuildStrategy(PxBVHBuildStrategyEnum value) {
        this.checkNotNull();
        Raw.setStaticBVHBuildStrategy(this.address, value.value);
    }

    public PxBVHBuildStrategyEnum getDynamicBVHBuildStrategy() {
        this.checkNotNull();
        return PxBVHBuildStrategyEnum.forValue(Raw.getDynamicBVHBuildStrategy(this.address));
    }

    public void setDynamicBVHBuildStrategy(PxBVHBuildStrategyEnum value) {
        this.checkNotNull();
        Raw.setDynamicBVHBuildStrategy(this.address, value.value);
    }

    public int getStaticNbObjectsPerNode() {
        this.checkNotNull();
        return Raw.getStaticNbObjectsPerNode(this.address);
    }

    public void setStaticNbObjectsPerNode(int value) {
        this.checkNotNull();
        Raw.setStaticNbObjectsPerNode(this.address, value);
    }

    public int getDynamicNbObjectsPerNode() {
        this.checkNotNull();
        return Raw.getDynamicNbObjectsPerNode(this.address);
    }

    public void setDynamicNbObjectsPerNode(int value) {
        this.checkNotNull();
        Raw.setDynamicNbObjectsPerNode(this.address, value);
    }

    public PxSceneQueryUpdateModeEnum getSceneQueryUpdateMode() {
        this.checkNotNull();
        return PxSceneQueryUpdateModeEnum.forValue(Raw.getSceneQueryUpdateMode(this.address));
    }

    public void setSceneQueryUpdateMode(PxSceneQueryUpdateModeEnum value) {
        this.checkNotNull();
        Raw.setSceneQueryUpdateMode(this.address, value.value);
    }

    public void setToDefault(PxTolerancesScale scale) {
        this.checkNotNull();
        Raw.setToDefault(this.address, scale.getAddress());
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native void PxSceneDesc_placed(long var0, long var2);

        public static native long PxSceneDesc(long var0);

        public static native void destroy(long var0);

        public static native long getGravity(long var0);

        public static native void setGravity(long var0, long var2);

        public static native long getSimulationEventCallback(long var0);

        public static native void setSimulationEventCallback(long var0, long var2);

        public static native long getFilterShaderData(long var0);

        public static native void setFilterShaderData(long var0, long var2);

        public static native int getFilterShaderDataSize(long var0);

        public static native void setFilterShaderDataSize(long var0, int var2);

        public static native long getFilterShader(long var0);

        public static native void setFilterShader(long var0, long var2);

        public static native int getKineKineFilteringMode(long var0);

        public static native void setKineKineFilteringMode(long var0, int var2);

        public static native int getStaticKineFilteringMode(long var0);

        public static native void setStaticKineFilteringMode(long var0, int var2);

        public static native int getBroadPhaseType(long var0);

        public static native void setBroadPhaseType(long var0, int var2);

        public static native long getLimits(long var0);

        public static native void setLimits(long var0, long var2);

        public static native int getFrictionType(long var0);

        public static native void setFrictionType(long var0, int var2);

        public static native int getSolverType(long var0);

        public static native void setSolverType(long var0, int var2);

        public static native float getBounceThresholdVelocity(long var0);

        public static native void setBounceThresholdVelocity(long var0, float var2);

        public static native float getFrictionOffsetThreshold(long var0);

        public static native void setFrictionOffsetThreshold(long var0, float var2);

        public static native float getFrictionCorrelationDistance(long var0);

        public static native void setFrictionCorrelationDistance(long var0, float var2);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);

        public static native long getCpuDispatcher(long var0);

        public static native void setCpuDispatcher(long var0, long var2);

        public static native long getUserData(long var0);

        public static native void setUserData(long var0, long var2);

        public static native int getSolverBatchSize(long var0);

        public static native void setSolverBatchSize(long var0, int var2);

        public static native int getSolverArticulationBatchSize(long var0);

        public static native void setSolverArticulationBatchSize(long var0, int var2);

        public static native int getNbContactDataBlocks(long var0);

        public static native void setNbContactDataBlocks(long var0, int var2);

        public static native int getMaxNbContactDataBlocks(long var0);

        public static native void setMaxNbContactDataBlocks(long var0, int var2);

        public static native float getMaxBiasCoefficient(long var0);

        public static native void setMaxBiasCoefficient(long var0, float var2);

        public static native int getContactReportStreamBufferSize(long var0);

        public static native void setContactReportStreamBufferSize(long var0, int var2);

        public static native int getCcdMaxPasses(long var0);

        public static native void setCcdMaxPasses(long var0, int var2);

        public static native float getCcdThreshold(long var0);

        public static native void setCcdThreshold(long var0, float var2);

        public static native float getCcdMaxSeparation(long var0);

        public static native void setCcdMaxSeparation(long var0, float var2);

        public static native float getWakeCounterResetValue(long var0);

        public static native void setWakeCounterResetValue(long var0, float var2);

        public static native long getSanityBounds(long var0);

        public static native void setSanityBounds(long var0, long var2);

        public static native int getGpuMaxNumPartitions(long var0);

        public static native void setGpuMaxNumPartitions(long var0, int var2);

        public static native int getGpuMaxNumStaticPartitions(long var0);

        public static native void setGpuMaxNumStaticPartitions(long var0, int var2);

        public static native int getGpuComputeVersion(long var0);

        public static native void setGpuComputeVersion(long var0, int var2);

        public static native int getContactPairSlabSize(long var0);

        public static native void setContactPairSlabSize(long var0, int var2);

        public static native int getStaticStructure(long var0);

        public static native void setStaticStructure(long var0, int var2);

        public static native int getDynamicStructure(long var0);

        public static native void setDynamicStructure(long var0, int var2);

        public static native int getDynamicTreeRebuildRateHint(long var0);

        public static native void setDynamicTreeRebuildRateHint(long var0, int var2);

        public static native int getDynamicTreeSecondaryPruner(long var0);

        public static native void setDynamicTreeSecondaryPruner(long var0, int var2);

        public static native int getStaticBVHBuildStrategy(long var0);

        public static native void setStaticBVHBuildStrategy(long var0, int var2);

        public static native int getDynamicBVHBuildStrategy(long var0);

        public static native void setDynamicBVHBuildStrategy(long var0, int var2);

        public static native int getStaticNbObjectsPerNode(long var0);

        public static native void setStaticNbObjectsPerNode(long var0, int var2);

        public static native int getDynamicNbObjectsPerNode(long var0);

        public static native void setDynamicNbObjectsPerNode(long var0, int var2);

        public static native int getSceneQueryUpdateMode(long var0);

        public static native void setSceneQueryUpdateMode(long var0, int var2);

        public static native void setToDefault(long var0, long var2);

        public static native boolean isValid(long var0);
    }
}

