/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxBaseTask;
import physx.common.PxBounds3;
import physx.common.PxCollection;
import physx.common.PxCpuDispatcher;
import physx.common.PxRenderBuffer;
import physx.common.PxVec3;
import physx.geometry.PxBVH;
import physx.physics.PxActor;
import physx.physics.PxActorTypeFlags;
import physx.physics.PxAggregate;
import physx.physics.PxArticulationReducedCoordinate;
import physx.physics.PxBroadPhaseCaps;
import physx.physics.PxBroadPhaseRegion;
import physx.physics.PxBroadPhaseRegionInfo;
import physx.physics.PxBroadPhaseTypeEnum;
import physx.physics.PxDominanceGroupPair;
import physx.physics.PxFrictionTypeEnum;
import physx.physics.PxPairFilteringModeEnum;
import physx.physics.PxPhysics;
import physx.physics.PxSceneFlagEnum;
import physx.physics.PxSceneFlags;
import physx.physics.PxSceneLimits;
import physx.physics.PxSceneSQSystem;
import physx.physics.PxSimulationEventCallback;
import physx.physics.PxSimulationFilterShader;
import physx.physics.PxSimulationStatistics;
import physx.physics.PxSolverTypeEnum;
import physx.support.PxPvdSceneClient;
import physx.support.PxVisualizationParameterEnum;

public class PxScene
extends PxSceneSQSystem {
    public static final int SIZEOF = PxScene.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxScene() {
    }

    private static native int __sizeOf();

    public static PxScene wrapPointer(long address) {
        return address != 0L ? new PxScene(address) : null;
    }

    public static PxScene arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxScene.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxScene(long address) {
        super(address);
    }

    public NativeObject getUserData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getUserData(this.address));
    }

    public void setUserData(NativeObject value) {
        this.checkNotNull();
        Raw.setUserData(this.address, value.getAddress());
    }

    public boolean addActor(PxActor actor) {
        this.checkNotNull();
        return Raw.addActor(this.address, actor.getAddress());
    }

    public boolean addActor(PxActor actor, PxBVH bvh) {
        this.checkNotNull();
        return Raw.addActor(this.address, actor.getAddress(), bvh.getAddress());
    }

    public void removeActor(PxActor actor) {
        this.checkNotNull();
        Raw.removeActor(this.address, actor.getAddress());
    }

    public void removeActor(PxActor actor, boolean wakeOnLostTouch) {
        this.checkNotNull();
        Raw.removeActor(this.address, actor.getAddress(), wakeOnLostTouch);
    }

    public boolean addAggregate(PxAggregate aggregate) {
        this.checkNotNull();
        return Raw.addAggregate(this.address, aggregate.getAddress());
    }

    public void removeAggregate(PxAggregate aggregate) {
        this.checkNotNull();
        Raw.removeAggregate(this.address, aggregate.getAddress());
    }

    public void removeAggregate(PxAggregate aggregate, boolean wakeOnLostTouch) {
        this.checkNotNull();
        Raw.removeAggregate(this.address, aggregate.getAddress(), wakeOnLostTouch);
    }

    public boolean addCollection(PxCollection collection) {
        this.checkNotNull();
        return Raw.addCollection(this.address, collection.getAddress());
    }

    public float getWakeCounterResetValue() {
        this.checkNotNull();
        return Raw.getWakeCounterResetValue(this.address);
    }

    public void shiftOrigin(PxVec3 shift) {
        this.checkNotNull();
        Raw.shiftOrigin(this.address, shift.getAddress());
    }

    public boolean addArticulation(PxArticulationReducedCoordinate articulation) {
        this.checkNotNull();
        return Raw.addArticulation(this.address, articulation.getAddress());
    }

    public void removeArticulation(PxArticulationReducedCoordinate articulation) {
        this.checkNotNull();
        Raw.removeArticulation(this.address, articulation.getAddress());
    }

    public void removeArticulation(PxArticulationReducedCoordinate articulation, boolean wakeOnLostTouch) {
        this.checkNotNull();
        Raw.removeArticulation(this.address, articulation.getAddress(), wakeOnLostTouch);
    }

    public int getNbActors(PxActorTypeFlags types) {
        this.checkNotNull();
        return Raw.getNbActors(this.address, types.getAddress());
    }

    public int getNbArticulations() {
        this.checkNotNull();
        return Raw.getNbArticulations(this.address);
    }

    public int getNbConstraints() {
        this.checkNotNull();
        return Raw.getNbConstraints(this.address);
    }

    public int getNbAggregates() {
        this.checkNotNull();
        return Raw.getNbAggregates(this.address);
    }

    public void setDominanceGroupPair(byte group1, byte group2, PxDominanceGroupPair dominance) {
        this.checkNotNull();
        Raw.setDominanceGroupPair(this.address, group1, group2, dominance.getAddress());
    }

    public PxDominanceGroupPair getDominanceGroupPair(byte group1, byte group2) {
        this.checkNotNull();
        PlatformChecks.requirePlatform(3, "physx.physics.PxScene");
        return PxDominanceGroupPair.wrapPointer(Raw.getDominanceGroupPair(this.address, group1, group2));
    }

    public PxCpuDispatcher getCpuDispatcher() {
        this.checkNotNull();
        return PxCpuDispatcher.wrapPointer(Raw.getCpuDispatcher(this.address));
    }

    public byte createClient() {
        this.checkNotNull();
        return Raw.createClient(this.address);
    }

    public void setSimulationEventCallback(PxSimulationEventCallback callback) {
        this.checkNotNull();
        Raw.setSimulationEventCallback(this.address, callback.getAddress());
    }

    public PxSimulationEventCallback getSimulationEventCallback() {
        this.checkNotNull();
        return PxSimulationEventCallback.wrapPointer(Raw.getSimulationEventCallback(this.address));
    }

    public void setFilterShaderData(NativeObject data, int dataSize) {
        this.checkNotNull();
        Raw.setFilterShaderData(this.address, data.getAddress(), dataSize);
    }

    public NativeObject getFilterShaderData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getFilterShaderData(this.address));
    }

    public int getFilterShaderDataSize() {
        this.checkNotNull();
        return Raw.getFilterShaderDataSize(this.address);
    }

    public PxSimulationFilterShader getFilterShader() {
        this.checkNotNull();
        return PxSimulationFilterShader.wrapPointer(Raw.getFilterShader(this.address));
    }

    public boolean resetFiltering(PxActor actor) {
        this.checkNotNull();
        return Raw.resetFiltering(this.address, actor.getAddress());
    }

    public PxPairFilteringModeEnum getKinematicKinematicFilteringMode() {
        this.checkNotNull();
        return PxPairFilteringModeEnum.forValue(Raw.getKinematicKinematicFilteringMode(this.address));
    }

    public PxPairFilteringModeEnum getStaticKinematicFilteringMode() {
        this.checkNotNull();
        return PxPairFilteringModeEnum.forValue(Raw.getStaticKinematicFilteringMode(this.address));
    }

    public boolean simulate(float elapsedTime) {
        this.checkNotNull();
        return Raw.simulate(this.address, elapsedTime);
    }

    public boolean simulate(float elapsedTime, PxBaseTask completionTask) {
        this.checkNotNull();
        return Raw.simulate(this.address, elapsedTime, completionTask.getAddress());
    }

    public boolean simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock) {
        this.checkNotNull();
        return Raw.simulate(this.address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress());
    }

    public boolean simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize) {
        this.checkNotNull();
        return Raw.simulate(this.address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize);
    }

    public boolean simulate(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation) {
        this.checkNotNull();
        return Raw.simulate(this.address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize, controlSimulation);
    }

    public boolean advance() {
        this.checkNotNull();
        return Raw.advance(this.address);
    }

    public boolean advance(PxBaseTask completionTask) {
        this.checkNotNull();
        return Raw.advance(this.address, completionTask.getAddress());
    }

    public boolean collide(float elapsedTime) {
        this.checkNotNull();
        return Raw.collide(this.address, elapsedTime);
    }

    public boolean collide(float elapsedTime, PxBaseTask completionTask) {
        this.checkNotNull();
        return Raw.collide(this.address, elapsedTime, completionTask.getAddress());
    }

    public boolean collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock) {
        this.checkNotNull();
        return Raw.collide(this.address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress());
    }

    public boolean collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize) {
        this.checkNotNull();
        return Raw.collide(this.address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize);
    }

    public boolean collide(float elapsedTime, PxBaseTask completionTask, NativeObject scratchMemBlock, int scratchMemBlockSize, boolean controlSimulation) {
        this.checkNotNull();
        return Raw.collide(this.address, elapsedTime, completionTask.getAddress(), scratchMemBlock.getAddress(), scratchMemBlockSize, controlSimulation);
    }

    public boolean checkResults() {
        this.checkNotNull();
        return Raw.checkResults(this.address);
    }

    public boolean checkResults(boolean block) {
        this.checkNotNull();
        return Raw.checkResults(this.address, block);
    }

    public boolean fetchCollision() {
        this.checkNotNull();
        return Raw.fetchCollision(this.address);
    }

    public boolean fetchCollision(boolean block) {
        this.checkNotNull();
        return Raw.fetchCollision(this.address, block);
    }

    public boolean fetchResults() {
        this.checkNotNull();
        return Raw.fetchResults(this.address);
    }

    public boolean fetchResults(boolean block) {
        this.checkNotNull();
        return Raw.fetchResults(this.address, block);
    }

    public void processCallbacks(PxBaseTask continuation) {
        this.checkNotNull();
        Raw.processCallbacks(this.address, continuation.getAddress());
    }

    public void fetchResultsParticleSystem() {
        this.checkNotNull();
        Raw.fetchResultsParticleSystem(this.address);
    }

    public void flushSimulation() {
        this.checkNotNull();
        Raw.flushSimulation(this.address);
    }

    public void flushSimulation(boolean sendPendingReports) {
        this.checkNotNull();
        Raw.flushSimulation(this.address, sendPendingReports);
    }

    public void setGravity(PxVec3 vec) {
        this.checkNotNull();
        Raw.setGravity(this.address, vec.getAddress());
    }

    public PxVec3 getGravity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getGravity(this.address));
    }

    public void setBounceThresholdVelocity(float t) {
        this.checkNotNull();
        Raw.setBounceThresholdVelocity(this.address, t);
    }

    public float getBounceThresholdVelocity() {
        this.checkNotNull();
        return Raw.getBounceThresholdVelocity(this.address);
    }

    public void setCCDMaxPasses(int ccdMaxPasses) {
        this.checkNotNull();
        Raw.setCCDMaxPasses(this.address, ccdMaxPasses);
    }

    public int getCCDMaxPasses() {
        this.checkNotNull();
        return Raw.getCCDMaxPasses(this.address);
    }

    public void setCCDMaxSeparation(float t) {
        this.checkNotNull();
        Raw.setCCDMaxSeparation(this.address, t);
    }

    public float getCCDMaxSeparation() {
        this.checkNotNull();
        return Raw.getCCDMaxSeparation(this.address);
    }

    public void setCCDThreshold(float t) {
        this.checkNotNull();
        Raw.setCCDThreshold(this.address, t);
    }

    public float getCCDThreshold() {
        this.checkNotNull();
        return Raw.getCCDThreshold(this.address);
    }

    public void setMaxBiasCoefficient(float t) {
        this.checkNotNull();
        Raw.setMaxBiasCoefficient(this.address, t);
    }

    public float getMaxBiasCoefficient() {
        this.checkNotNull();
        return Raw.getMaxBiasCoefficient(this.address);
    }

    public void setFrictionOffsetThreshold(float t) {
        this.checkNotNull();
        Raw.setFrictionOffsetThreshold(this.address, t);
    }

    public float getFrictionOffsetThreshold() {
        this.checkNotNull();
        return Raw.getFrictionOffsetThreshold(this.address);
    }

    public void setFrictionCorrelationDistance(float t) {
        this.checkNotNull();
        Raw.setFrictionCorrelationDistance(this.address, t);
    }

    public float getFrictionCorrelationDistance() {
        this.checkNotNull();
        return Raw.getFrictionCorrelationDistance(this.address);
    }

    @Deprecated
    public PxFrictionTypeEnum getFrictionType() {
        this.checkNotNull();
        return PxFrictionTypeEnum.forValue(Raw.getFrictionType(this.address));
    }

    public PxSolverTypeEnum getSolverType() {
        this.checkNotNull();
        return PxSolverTypeEnum.forValue(Raw.getSolverType(this.address));
    }

    public PxRenderBuffer getRenderBuffer() {
        this.checkNotNull();
        return PxRenderBuffer.wrapPointer(Raw.getRenderBuffer(this.address));
    }

    public boolean setVisualizationParameter(PxVisualizationParameterEnum param, float value) {
        this.checkNotNull();
        return Raw.setVisualizationParameter(this.address, param.value, value);
    }

    public float getVisualizationParameter(PxVisualizationParameterEnum paramEnum) {
        this.checkNotNull();
        return Raw.getVisualizationParameter(this.address, paramEnum.value);
    }

    public void setVisualizationCullingBox(PxBounds3 box) {
        this.checkNotNull();
        Raw.setVisualizationCullingBox(this.address, box.getAddress());
    }

    public PxBounds3 getVisualizationCullingBox() {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getVisualizationCullingBox(this.address));
    }

    public void getSimulationStatistics(PxSimulationStatistics stats) {
        this.checkNotNull();
        Raw.getSimulationStatistics(this.address, stats.getAddress());
    }

    public PxBroadPhaseTypeEnum getBroadPhaseType() {
        this.checkNotNull();
        return PxBroadPhaseTypeEnum.forValue(Raw.getBroadPhaseType(this.address));
    }

    public boolean getBroadPhaseCaps(PxBroadPhaseCaps caps) {
        this.checkNotNull();
        return Raw.getBroadPhaseCaps(this.address, caps.getAddress());
    }

    public int getNbBroadPhaseRegions() {
        this.checkNotNull();
        return Raw.getNbBroadPhaseRegions(this.address);
    }

    public int getBroadPhaseRegions(PxBroadPhaseRegionInfo userBuffer, int bufferSize) {
        this.checkNotNull();
        return Raw.getBroadPhaseRegions(this.address, userBuffer.getAddress(), bufferSize);
    }

    public int getBroadPhaseRegions(PxBroadPhaseRegionInfo userBuffer, int bufferSize, int startIndex) {
        this.checkNotNull();
        return Raw.getBroadPhaseRegions(this.address, userBuffer.getAddress(), bufferSize, startIndex);
    }

    public int addBroadPhaseRegion(PxBroadPhaseRegion region) {
        this.checkNotNull();
        return Raw.addBroadPhaseRegion(this.address, region.getAddress());
    }

    public int addBroadPhaseRegion(PxBroadPhaseRegion region, boolean populateRegion) {
        this.checkNotNull();
        return Raw.addBroadPhaseRegion(this.address, region.getAddress(), populateRegion);
    }

    public boolean removeBroadPhaseRegion(int handle) {
        this.checkNotNull();
        return Raw.removeBroadPhaseRegion(this.address, handle);
    }

    public void lockRead() {
        this.checkNotNull();
        Raw.lockRead(this.address);
    }

    public void lockRead(String file) {
        this.checkNotNull();
        Raw.lockRead(this.address, file);
    }

    public void lockRead(String file, int line) {
        this.checkNotNull();
        Raw.lockRead(this.address, file, line);
    }

    public void unlockRead() {
        this.checkNotNull();
        Raw.unlockRead(this.address);
    }

    public void lockWrite() {
        this.checkNotNull();
        Raw.lockWrite(this.address);
    }

    public void lockWrite(String file) {
        this.checkNotNull();
        Raw.lockWrite(this.address, file);
    }

    public void lockWrite(String file, int line) {
        this.checkNotNull();
        Raw.lockWrite(this.address, file, line);
    }

    public void unlockWrite() {
        this.checkNotNull();
        Raw.unlockWrite(this.address);
    }

    public void setNbContactDataBlocks(int numBlocks) {
        this.checkNotNull();
        Raw.setNbContactDataBlocks(this.address, numBlocks);
    }

    public int getNbContactDataBlocksUsed() {
        this.checkNotNull();
        return Raw.getNbContactDataBlocksUsed(this.address);
    }

    public int getMaxNbContactDataBlocksUsed() {
        this.checkNotNull();
        return Raw.getMaxNbContactDataBlocksUsed(this.address);
    }

    public int getContactReportStreamBufferSize() {
        this.checkNotNull();
        return Raw.getContactReportStreamBufferSize(this.address);
    }

    public void setSolverBatchSize(int solverBatchSize) {
        this.checkNotNull();
        Raw.setSolverBatchSize(this.address, solverBatchSize);
    }

    public int getSolverBatchSize() {
        this.checkNotNull();
        return Raw.getSolverBatchSize(this.address);
    }

    public void setSolverArticulationBatchSize(int solverBatchSize) {
        this.checkNotNull();
        Raw.setSolverArticulationBatchSize(this.address, solverBatchSize);
    }

    public int getSolverArticulationBatchSize() {
        this.checkNotNull();
        return Raw.getSolverArticulationBatchSize(this.address);
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public void setFlag(PxSceneFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setFlag(this.address, flag.value, value);
    }

    public PxSceneFlags getFlags() {
        this.checkNotNull();
        return PxSceneFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setLimits(PxSceneLimits limits) {
        this.checkNotNull();
        Raw.setLimits(this.address, limits.getAddress());
    }

    public PxSceneLimits getLimits() {
        this.checkNotNull();
        return PxSceneLimits.wrapPointer(Raw.getLimits(this.address));
    }

    public PxPhysics getPhysics() {
        this.checkNotNull();
        return PxPhysics.wrapPointer(Raw.getPhysics(this.address));
    }

    public int getTimestamp() {
        this.checkNotNull();
        return Raw.getTimestamp(this.address);
    }

    public PxPvdSceneClient getScenePvdClient() {
        this.checkNotNull();
        return PxPvdSceneClient.wrapPointer(Raw.getScenePvdClient(this.address));
    }

    public static class Raw {
        public static native long getUserData(long var0);

        public static native void setUserData(long var0, long var2);

        public static native boolean addActor(long var0, long var2);

        public static native boolean addActor(long var0, long var2, long var4);

        public static native void removeActor(long var0, long var2);

        public static native void removeActor(long var0, long var2, boolean var4);

        public static native boolean addAggregate(long var0, long var2);

        public static native void removeAggregate(long var0, long var2);

        public static native void removeAggregate(long var0, long var2, boolean var4);

        public static native boolean addCollection(long var0, long var2);

        public static native float getWakeCounterResetValue(long var0);

        public static native void shiftOrigin(long var0, long var2);

        public static native boolean addArticulation(long var0, long var2);

        public static native void removeArticulation(long var0, long var2);

        public static native void removeArticulation(long var0, long var2, boolean var4);

        public static native int getNbActors(long var0, long var2);

        public static native int getNbArticulations(long var0);

        public static native int getNbConstraints(long var0);

        public static native int getNbAggregates(long var0);

        public static native void setDominanceGroupPair(long var0, byte var2, byte var3, long var4);

        public static native long getDominanceGroupPair(long var0, byte var2, byte var3);

        public static native long getCpuDispatcher(long var0);

        public static native byte createClient(long var0);

        public static native void setSimulationEventCallback(long var0, long var2);

        public static native long getSimulationEventCallback(long var0);

        public static native void setFilterShaderData(long var0, long var2, int var4);

        public static native long getFilterShaderData(long var0);

        public static native int getFilterShaderDataSize(long var0);

        public static native long getFilterShader(long var0);

        public static native boolean resetFiltering(long var0, long var2);

        public static native int getKinematicKinematicFilteringMode(long var0);

        public static native int getStaticKinematicFilteringMode(long var0);

        public static native boolean simulate(long var0, float var2);

        public static native boolean simulate(long var0, float var2, long var3);

        public static native boolean simulate(long var0, float var2, long var3, long var5);

        public static native boolean simulate(long var0, float var2, long var3, long var5, int var7);

        public static native boolean simulate(long var0, float var2, long var3, long var5, int var7, boolean var8);

        public static native boolean advance(long var0);

        public static native boolean advance(long var0, long var2);

        public static native boolean collide(long var0, float var2);

        public static native boolean collide(long var0, float var2, long var3);

        public static native boolean collide(long var0, float var2, long var3, long var5);

        public static native boolean collide(long var0, float var2, long var3, long var5, int var7);

        public static native boolean collide(long var0, float var2, long var3, long var5, int var7, boolean var8);

        public static native boolean checkResults(long var0);

        public static native boolean checkResults(long var0, boolean var2);

        public static native boolean fetchCollision(long var0);

        public static native boolean fetchCollision(long var0, boolean var2);

        public static native boolean fetchResults(long var0);

        public static native boolean fetchResults(long var0, boolean var2);

        public static native void processCallbacks(long var0, long var2);

        public static native void fetchResultsParticleSystem(long var0);

        public static native void flushSimulation(long var0);

        public static native void flushSimulation(long var0, boolean var2);

        public static native void setGravity(long var0, long var2);

        public static native long getGravity(long var0);

        public static native void setBounceThresholdVelocity(long var0, float var2);

        public static native float getBounceThresholdVelocity(long var0);

        public static native void setCCDMaxPasses(long var0, int var2);

        public static native int getCCDMaxPasses(long var0);

        public static native void setCCDMaxSeparation(long var0, float var2);

        public static native float getCCDMaxSeparation(long var0);

        public static native void setCCDThreshold(long var0, float var2);

        public static native float getCCDThreshold(long var0);

        public static native void setMaxBiasCoefficient(long var0, float var2);

        public static native float getMaxBiasCoefficient(long var0);

        public static native void setFrictionOffsetThreshold(long var0, float var2);

        public static native float getFrictionOffsetThreshold(long var0);

        public static native void setFrictionCorrelationDistance(long var0, float var2);

        public static native float getFrictionCorrelationDistance(long var0);

        public static native int getFrictionType(long var0);

        public static native int getSolverType(long var0);

        public static native long getRenderBuffer(long var0);

        public static native boolean setVisualizationParameter(long var0, int var2, float var3);

        public static native float getVisualizationParameter(long var0, int var2);

        public static native void setVisualizationCullingBox(long var0, long var2);

        public static native long getVisualizationCullingBox(long var0);

        public static native void getSimulationStatistics(long var0, long var2);

        public static native int getBroadPhaseType(long var0);

        public static native boolean getBroadPhaseCaps(long var0, long var2);

        public static native int getNbBroadPhaseRegions(long var0);

        public static native int getBroadPhaseRegions(long var0, long var2, int var4);

        public static native int getBroadPhaseRegions(long var0, long var2, int var4, int var5);

        public static native int addBroadPhaseRegion(long var0, long var2);

        public static native int addBroadPhaseRegion(long var0, long var2, boolean var4);

        public static native boolean removeBroadPhaseRegion(long var0, int var2);

        public static native void lockRead(long var0);

        public static native void lockRead(long var0, String var2);

        public static native void lockRead(long var0, String var2, int var3);

        public static native void unlockRead(long var0);

        public static native void lockWrite(long var0);

        public static native void lockWrite(long var0, String var2);

        public static native void lockWrite(long var0, String var2, int var3);

        public static native void unlockWrite(long var0);

        public static native void setNbContactDataBlocks(long var0, int var2);

        public static native int getNbContactDataBlocksUsed(long var0);

        public static native int getMaxNbContactDataBlocksUsed(long var0);

        public static native int getContactReportStreamBufferSize(long var0);

        public static native void setSolverBatchSize(long var0, int var2);

        public static native int getSolverBatchSize(long var0);

        public static native void setSolverArticulationBatchSize(long var0, int var2);

        public static native int getSolverArticulationBatchSize(long var0);

        public static native void release(long var0);

        public static native void setFlag(long var0, int var2, boolean var3);

        public static native long getFlags(long var0);

        public static native void setLimits(long var0, long var2);

        public static native long getLimits(long var0);

        public static native long getPhysics(long var0);

        public static native int getTimestamp(long var0);

        public static native long getScenePvdClient(long var0);
    }
}

