/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidBodyFlags;

public class PxRigidBody
extends PxRigidActor {
    public static final int SIZEOF = PxRigidBody.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxRigidBody() {
    }

    private static native int __sizeOf();

    public static PxRigidBody wrapPointer(long address) {
        return address != 0L ? new PxRigidBody(address) : null;
    }

    public static PxRigidBody arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRigidBody.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRigidBody(long address) {
        super(address);
    }

    public void setCMassLocalPose(PxTransform pose) {
        this.checkNotNull();
        Raw.setCMassLocalPose(this.address, pose.getAddress());
    }

    public PxTransform getCMassLocalPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getCMassLocalPose(this.address));
    }

    public void setMass(float mass) {
        this.checkNotNull();
        Raw.setMass(this.address, mass);
    }

    public float getMass() {
        this.checkNotNull();
        return Raw.getMass(this.address);
    }

    public float getInvMass() {
        this.checkNotNull();
        return Raw.getInvMass(this.address);
    }

    public void setMassSpaceInertiaTensor(PxVec3 m) {
        this.checkNotNull();
        Raw.setMassSpaceInertiaTensor(this.address, m.getAddress());
    }

    public PxVec3 getMassSpaceInertiaTensor() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getMassSpaceInertiaTensor(this.address));
    }

    public PxVec3 getMassSpaceInvInertiaTensor() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getMassSpaceInvInertiaTensor(this.address));
    }

    public void setLinearDamping(float linDamp) {
        this.checkNotNull();
        Raw.setLinearDamping(this.address, linDamp);
    }

    public float getLinearDamping() {
        this.checkNotNull();
        return Raw.getLinearDamping(this.address);
    }

    public void setAngularDamping(float angDamp) {
        this.checkNotNull();
        Raw.setAngularDamping(this.address, angDamp);
    }

    public float getAngularDamping() {
        this.checkNotNull();
        return Raw.getAngularDamping(this.address);
    }

    public PxVec3 getLinearVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getLinearVelocity(this.address));
    }

    public PxVec3 getAngularVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getAngularVelocity(this.address));
    }

    public void setMaxLinearVelocity(float maxLinVel) {
        this.checkNotNull();
        Raw.setMaxLinearVelocity(this.address, maxLinVel);
    }

    public float getMaxLinearVelocity() {
        this.checkNotNull();
        return Raw.getMaxLinearVelocity(this.address);
    }

    public void setMaxAngularVelocity(float maxAngVel) {
        this.checkNotNull();
        Raw.setMaxAngularVelocity(this.address, maxAngVel);
    }

    public float getMaxAngularVelocity() {
        this.checkNotNull();
        return Raw.getMaxAngularVelocity(this.address);
    }

    public void addForce(PxVec3 force) {
        this.checkNotNull();
        Raw.addForce(this.address, force.getAddress());
    }

    public void addForce(PxVec3 force, PxForceModeEnum mode) {
        this.checkNotNull();
        Raw.addForce(this.address, force.getAddress(), mode.value);
    }

    public void addForce(PxVec3 force, PxForceModeEnum mode, boolean autowake) {
        this.checkNotNull();
        Raw.addForce(this.address, force.getAddress(), mode.value, autowake);
    }

    public void addTorque(PxVec3 torque) {
        this.checkNotNull();
        Raw.addTorque(this.address, torque.getAddress());
    }

    public void addTorque(PxVec3 torque, PxForceModeEnum mode) {
        this.checkNotNull();
        Raw.addTorque(this.address, torque.getAddress(), mode.value);
    }

    public void addTorque(PxVec3 torque, PxForceModeEnum mode, boolean autowake) {
        this.checkNotNull();
        Raw.addTorque(this.address, torque.getAddress(), mode.value, autowake);
    }

    public void clearForce(PxForceModeEnum mode) {
        this.checkNotNull();
        Raw.clearForce(this.address, mode.value);
    }

    public void clearTorque(PxForceModeEnum mode) {
        this.checkNotNull();
        Raw.clearTorque(this.address, mode.value);
    }

    public void setForceAndTorque(PxVec3 force, PxVec3 torque) {
        this.checkNotNull();
        Raw.setForceAndTorque(this.address, force.getAddress(), torque.getAddress());
    }

    public void setForceAndTorque(PxVec3 force, PxVec3 torque, PxForceModeEnum mode) {
        this.checkNotNull();
        Raw.setForceAndTorque(this.address, force.getAddress(), torque.getAddress(), mode.value);
    }

    public void setRigidBodyFlag(PxRigidBodyFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setRigidBodyFlag(this.address, flag.value, value);
    }

    public void setRigidBodyFlags(PxRigidBodyFlags inFlags) {
        this.checkNotNull();
        Raw.setRigidBodyFlags(this.address, inFlags.getAddress());
    }

    public PxRigidBodyFlags getRigidBodyFlags() {
        this.checkNotNull();
        return PxRigidBodyFlags.wrapPointer(Raw.getRigidBodyFlags(this.address));
    }

    public void setMinCCDAdvanceCoefficient(float advanceCoefficient) {
        this.checkNotNull();
        Raw.setMinCCDAdvanceCoefficient(this.address, advanceCoefficient);
    }

    public float getMinCCDAdvanceCoefficient() {
        this.checkNotNull();
        return Raw.getMinCCDAdvanceCoefficient(this.address);
    }

    public void setMaxDepenetrationVelocity(float biasClamp) {
        this.checkNotNull();
        Raw.setMaxDepenetrationVelocity(this.address, biasClamp);
    }

    public float getMaxDepenetrationVelocity() {
        this.checkNotNull();
        return Raw.getMaxDepenetrationVelocity(this.address);
    }

    public void setMaxContactImpulse(float maxImpulse) {
        this.checkNotNull();
        Raw.setMaxContactImpulse(this.address, maxImpulse);
    }

    public float getMaxContactImpulse() {
        this.checkNotNull();
        return Raw.getMaxContactImpulse(this.address);
    }

    public void setContactSlopCoefficient(float slopCoefficient) {
        this.checkNotNull();
        Raw.setContactSlopCoefficient(this.address, slopCoefficient);
    }

    public float getContactSlopCoefficient() {
        this.checkNotNull();
        return Raw.getContactSlopCoefficient(this.address);
    }

    public static class Raw {
        public static native void setCMassLocalPose(long var0, long var2);

        public static native long getCMassLocalPose(long var0);

        public static native void setMass(long var0, float var2);

        public static native float getMass(long var0);

        public static native float getInvMass(long var0);

        public static native void setMassSpaceInertiaTensor(long var0, long var2);

        public static native long getMassSpaceInertiaTensor(long var0);

        public static native long getMassSpaceInvInertiaTensor(long var0);

        public static native void setLinearDamping(long var0, float var2);

        public static native float getLinearDamping(long var0);

        public static native void setAngularDamping(long var0, float var2);

        public static native float getAngularDamping(long var0);

        public static native long getLinearVelocity(long var0);

        public static native long getAngularVelocity(long var0);

        public static native void setMaxLinearVelocity(long var0, float var2);

        public static native float getMaxLinearVelocity(long var0);

        public static native void setMaxAngularVelocity(long var0, float var2);

        public static native float getMaxAngularVelocity(long var0);

        public static native void addForce(long var0, long var2);

        public static native void addForce(long var0, long var2, int var4);

        public static native void addForce(long var0, long var2, int var4, boolean var5);

        public static native void addTorque(long var0, long var2);

        public static native void addTorque(long var0, long var2, int var4);

        public static native void addTorque(long var0, long var2, int var4, boolean var5);

        public static native void clearForce(long var0, int var2);

        public static native void clearTorque(long var0, int var2);

        public static native void setForceAndTorque(long var0, long var2, long var4);

        public static native void setForceAndTorque(long var0, long var2, long var4, int var6);

        public static native void setRigidBodyFlag(long var0, int var2, boolean var3);

        public static native void setRigidBodyFlags(long var0, long var2);

        public static native long getRigidBodyFlags(long var0);

        public static native void setMinCCDAdvanceCoefficient(long var0, float var2);

        public static native float getMinCCDAdvanceCoefficient(long var0);

        public static native void setMaxDepenetrationVelocity(long var0, float var2);

        public static native float getMaxDepenetrationVelocity(long var0);

        public static native void setMaxContactImpulse(long var0, float var2);

        public static native float getMaxContactImpulse(long var0);

        public static native void setContactSlopCoefficient(long var0, float var2);

        public static native float getContactSlopCoefficient(long var0);
    }
}

