/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxTransform;
import physx.physics.PxActor;
import physx.physics.PxShape;
import physx.support.PxShapePtr;

public class PxRigidActor
extends PxActor {
    public static final int SIZEOF = PxRigidActor.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxRigidActor() {
    }

    private static native int __sizeOf();

    public static PxRigidActor wrapPointer(long address) {
        return address != 0L ? new PxRigidActor(address) : null;
    }

    public static PxRigidActor arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRigidActor.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRigidActor(long address) {
        super(address);
    }

    public PxTransform getGlobalPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getGlobalPose(this.address));
    }

    public void setGlobalPose(PxTransform pose) {
        this.checkNotNull();
        Raw.setGlobalPose(this.address, pose.getAddress());
    }

    public void setGlobalPose(PxTransform pose, boolean autowake) {
        this.checkNotNull();
        Raw.setGlobalPose(this.address, pose.getAddress(), autowake);
    }

    public boolean attachShape(PxShape shape) {
        this.checkNotNull();
        return Raw.attachShape(this.address, shape.getAddress());
    }

    public void detachShape(PxShape shape) {
        this.checkNotNull();
        Raw.detachShape(this.address, shape.getAddress());
    }

    public void detachShape(PxShape shape, boolean wakeOnLostTouch) {
        this.checkNotNull();
        Raw.detachShape(this.address, shape.getAddress(), wakeOnLostTouch);
    }

    public int getNbShapes() {
        this.checkNotNull();
        return Raw.getNbShapes(this.address);
    }

    public int getShapes(PxShapePtr userBuffer, int bufferSize, int startIndex) {
        this.checkNotNull();
        return Raw.getShapes(this.address, userBuffer.getAddress(), bufferSize, startIndex);
    }

    public int getNbConstraints() {
        this.checkNotNull();
        return Raw.getNbConstraints(this.address);
    }

    public static class Raw {
        public static native long getGlobalPose(long var0);

        public static native void setGlobalPose(long var0, long var2);

        public static native void setGlobalPose(long var0, long var2, boolean var4);

        public static native boolean attachShape(long var0, long var2);

        public static native void detachShape(long var0, long var2);

        public static native void detachShape(long var0, long var2, boolean var4);

        public static native int getNbShapes(long var0);

        public static native int getShapes(long var0, long var2, int var4, int var5);

        public static native int getNbConstraints(long var0);
    }
}

