/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.physics.PxBaseMaterial;
import physx.physics.PxCombineModeEnum;
import physx.physics.PxMaterialFlagEnum;
import physx.physics.PxMaterialFlags;

public class PxMaterial
extends PxBaseMaterial {
    public static final int SIZEOF = PxMaterial.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxMaterial() {
    }

    private static native int __sizeOf();

    public static PxMaterial wrapPointer(long address) {
        return address != 0L ? new PxMaterial(address) : null;
    }

    public static PxMaterial arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxMaterial.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxMaterial(long address) {
        super(address);
    }

    public NativeObject getUserData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getUserData(this.address));
    }

    public void setUserData(NativeObject value) {
        this.checkNotNull();
        Raw.setUserData(this.address, value.getAddress());
    }

    public void setDynamicFriction(float coef) {
        this.checkNotNull();
        Raw.setDynamicFriction(this.address, coef);
    }

    public float getDynamicFriction() {
        this.checkNotNull();
        return Raw.getDynamicFriction(this.address);
    }

    public void setStaticFriction(float coef) {
        this.checkNotNull();
        Raw.setStaticFriction(this.address, coef);
    }

    public float getStaticFriction() {
        this.checkNotNull();
        return Raw.getStaticFriction(this.address);
    }

    public void setRestitution(float coef) {
        this.checkNotNull();
        Raw.setRestitution(this.address, coef);
    }

    public float getRestitution() {
        this.checkNotNull();
        return Raw.getRestitution(this.address);
    }

    public void setFlag(PxMaterialFlagEnum flag, boolean b) {
        this.checkNotNull();
        Raw.setFlag(this.address, flag.value, b);
    }

    public void setFlags(PxMaterialFlags flags) {
        this.checkNotNull();
        Raw.setFlags(this.address, flags.getAddress());
    }

    public PxMaterialFlags getFlags() {
        this.checkNotNull();
        return PxMaterialFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFrictionCombineMode(PxCombineModeEnum combMode) {
        this.checkNotNull();
        Raw.setFrictionCombineMode(this.address, combMode.value);
    }

    public PxCombineModeEnum getFrictionCombineMode() {
        this.checkNotNull();
        return PxCombineModeEnum.forValue(Raw.getFrictionCombineMode(this.address));
    }

    public void setRestitutionCombineMode(PxCombineModeEnum combMode) {
        this.checkNotNull();
        Raw.setRestitutionCombineMode(this.address, combMode.value);
    }

    public PxCombineModeEnum getRestitutionCombineMode() {
        this.checkNotNull();
        return PxCombineModeEnum.forValue(Raw.getRestitutionCombineMode(this.address));
    }

    public static class Raw {
        public static native long getUserData(long var0);

        public static native void setUserData(long var0, long var2);

        public static native void setDynamicFriction(long var0, float var2);

        public static native float getDynamicFriction(long var0);

        public static native void setStaticFriction(long var0, float var2);

        public static native float getStaticFriction(long var0);

        public static native void setRestitution(long var0, float var2);

        public static native float getRestitution(long var0);

        public static native void setFlag(long var0, int var2, boolean var3);

        public static native void setFlags(long var0, long var2);

        public static native long getFlags(long var0);

        public static native void setFrictionCombineMode(long var0, int var2);

        public static native int getFrictionCombineMode(long var0);

        public static native void setRestitutionCombineMode(long var0, int var2);

        public static native int getRestitutionCombineMode(long var0);
    }
}

