/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.physics.PxContactPairFlags;
import physx.physics.PxContactPairPoint;
import physx.physics.PxPairFlags;
import physx.physics.PxShape;

public class PxContactPair
extends NativeObject {
    public static final int SIZEOF = PxContactPair.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxContactPair() {
    }

    private static native int __sizeOf();

    public static PxContactPair wrapPointer(long address) {
        return address != 0L ? new PxContactPair(address) : null;
    }

    public static PxContactPair arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxContactPair.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxContactPair(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxShape getShapes(int index) {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.getShapes(this.address, index));
    }

    public void setShapes(int index, PxShape value) {
        this.checkNotNull();
        Raw.setShapes(this.address, index, value.getAddress());
    }

    public byte getContactCount() {
        this.checkNotNull();
        return Raw.getContactCount(this.address);
    }

    public void setContactCount(byte value) {
        this.checkNotNull();
        Raw.setContactCount(this.address, value);
    }

    public byte getPatchCount() {
        this.checkNotNull();
        return Raw.getPatchCount(this.address);
    }

    public void setPatchCount(byte value) {
        this.checkNotNull();
        Raw.setPatchCount(this.address, value);
    }

    public PxContactPairFlags getFlags() {
        this.checkNotNull();
        return PxContactPairFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxContactPairFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public PxPairFlags getEvents() {
        this.checkNotNull();
        return PxPairFlags.wrapPointer(Raw.getEvents(this.address));
    }

    public void setEvents(PxPairFlags value) {
        this.checkNotNull();
        Raw.setEvents(this.address, value.getAddress());
    }

    public int extractContacts(PxContactPairPoint userBuffer, int bufferSize) {
        this.checkNotNull();
        return Raw.extractContacts(this.address, userBuffer.getAddress(), bufferSize);
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getShapes(long var0, int var2);

        public static native void setShapes(long var0, int var2, long var3);

        public static native byte getContactCount(long var0);

        public static native void setContactCount(long var0, byte var2);

        public static native byte getPatchCount(long var0);

        public static native void setPatchCount(long var0, byte var2);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);

        public static native long getEvents(long var0);

        public static native void setEvents(long var0, long var2);

        public static native int extractContacts(long var0, long var2, int var4);
    }
}

