/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.common.PxBase;
import physx.common.PxVec3;
import physx.physics.PxConstraint;
import physx.physics.PxConstraintSolverPrep;

public class PxConstraintConnector
extends NativeObject {
    public static final int SIZEOF = PxConstraintConnector.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxConstraintConnector() {
    }

    private static native int __sizeOf();

    public static PxConstraintConnector wrapPointer(long address) {
        return address != 0L ? new PxConstraintConnector(address) : null;
    }

    public static PxConstraintConnector arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxConstraintConnector.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxConstraintConnector(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public void prepareData() {
        this.checkNotNull();
        Raw.prepareData(this.address);
    }

    public void updateOmniPvdProperties() {
        this.checkNotNull();
        Raw.updateOmniPvdProperties(this.address);
    }

    public void onConstraintRelease() {
        this.checkNotNull();
        Raw.onConstraintRelease(this.address);
    }

    public void onComShift(int actor) {
        this.checkNotNull();
        Raw.onComShift(this.address, actor);
    }

    public void onOriginShift(PxVec3 shift) {
        this.checkNotNull();
        Raw.onOriginShift(this.address, shift.getAddress());
    }

    public PxBase getSerializable() {
        this.checkNotNull();
        return PxBase.wrapPointer(Raw.getSerializable(this.address));
    }

    public PxConstraintSolverPrep getPrep() {
        this.checkNotNull();
        return PxConstraintSolverPrep.wrapPointer(Raw.getPrep(this.address));
    }

    public void getConstantBlock() {
        this.checkNotNull();
        Raw.getConstantBlock(this.address);
    }

    public void connectToConstraint(PxConstraint constraint) {
        this.checkNotNull();
        Raw.connectToConstraint(this.address, constraint.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native void prepareData(long var0);

        public static native void updateOmniPvdProperties(long var0);

        public static native void onConstraintRelease(long var0);

        public static native void onComShift(long var0, int var2);

        public static native void onOriginShift(long var0, long var2);

        public static native long getSerializable(long var0);

        public static native long getPrep(long var0);

        public static native void getConstantBlock(long var0);

        public static native void connectToConstraint(long var0, long var2);
    }
}

