/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxBase;
import physx.common.PxVec3;
import physx.physics.PxConstraintFlagEnum;
import physx.physics.PxConstraintFlags;
import physx.physics.PxRigidActor;
import physx.physics.PxScene;

public class PxConstraint
extends PxBase {
    public static final int SIZEOF = PxConstraint.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxConstraint() {
    }

    private static native int __sizeOf();

    public static PxConstraint wrapPointer(long address) {
        return address != 0L ? new PxConstraint(address) : null;
    }

    public static PxConstraint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxConstraint.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxConstraint(long address) {
        super(address);
    }

    public PxScene getScene() {
        this.checkNotNull();
        return PxScene.wrapPointer(Raw.getScene(this.address));
    }

    public void setActors(PxRigidActor actor0, PxRigidActor actor1) {
        this.checkNotNull();
        Raw.setActors(this.address, actor0.getAddress(), actor1.getAddress());
    }

    public void markDirty() {
        this.checkNotNull();
        Raw.markDirty(this.address);
    }

    public void setFlags(PxConstraintFlags flags) {
        this.checkNotNull();
        Raw.setFlags(this.address, flags.getAddress());
    }

    public PxConstraintFlags getFlags() {
        this.checkNotNull();
        return PxConstraintFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlag(PxConstraintFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setFlag(this.address, flag.value, value);
    }

    public void getForce(PxVec3 linear, PxVec3 angular) {
        this.checkNotNull();
        Raw.getForce(this.address, linear.getAddress(), angular.getAddress());
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public void setBreakForce(float linear, float angular) {
        this.checkNotNull();
        Raw.setBreakForce(this.address, linear, angular);
    }

    public void setMinResponseThreshold(float threshold) {
        this.checkNotNull();
        Raw.setMinResponseThreshold(this.address, threshold);
    }

    public float getMinResponseThreshold() {
        this.checkNotNull();
        return Raw.getMinResponseThreshold(this.address);
    }

    public static class Raw {
        public static native long getScene(long var0);

        public static native void setActors(long var0, long var2, long var4);

        public static native void markDirty(long var0);

        public static native void setFlags(long var0, long var2);

        public static native long getFlags(long var0);

        public static native void setFlag(long var0, int var2, boolean var3);

        public static native void getForce(long var0, long var2, long var4);

        public static native boolean isValid(long var0);

        public static native void setBreakForce(long var0, float var2, float var3);

        public static native void setMinResponseThreshold(long var0, float var2);

        public static native float getMinResponseThreshold(long var0);
    }
}

