/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxBase;
import physx.common.PxTransform;
import physx.physics.PxArticulationAxisEnum;
import physx.physics.PxArticulationDrive;
import physx.physics.PxArticulationJointTypeEnum;
import physx.physics.PxArticulationLimit;
import physx.physics.PxArticulationLink;
import physx.physics.PxArticulationMotionEnum;

public class PxArticulationJointReducedCoordinate
extends PxBase {
    public static final int SIZEOF = PxArticulationJointReducedCoordinate.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxArticulationJointReducedCoordinate() {
    }

    private static native int __sizeOf();

    public static PxArticulationJointReducedCoordinate wrapPointer(long address) {
        return address != 0L ? new PxArticulationJointReducedCoordinate(address) : null;
    }

    public static PxArticulationJointReducedCoordinate arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxArticulationJointReducedCoordinate.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxArticulationJointReducedCoordinate(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxArticulationLink getParentArticulationLink() {
        this.checkNotNull();
        return PxArticulationLink.wrapPointer(Raw.getParentArticulationLink(this.address));
    }

    public void setParentPose(PxTransform pose) {
        this.checkNotNull();
        Raw.setParentPose(this.address, pose.getAddress());
    }

    public PxTransform getParentPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getParentPose(this.address));
    }

    public PxArticulationLink getChildArticulationLink() {
        this.checkNotNull();
        return PxArticulationLink.wrapPointer(Raw.getChildArticulationLink(this.address));
    }

    public void setChildPose(PxTransform pose) {
        this.checkNotNull();
        Raw.setChildPose(this.address, pose.getAddress());
    }

    public PxTransform getChildPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getChildPose(this.address));
    }

    public void setJointType(PxArticulationJointTypeEnum jointType) {
        this.checkNotNull();
        Raw.setJointType(this.address, jointType.value);
    }

    public PxArticulationJointTypeEnum getJointType() {
        this.checkNotNull();
        return PxArticulationJointTypeEnum.forValue(Raw.getJointType(this.address));
    }

    public void setMotion(PxArticulationAxisEnum axis, PxArticulationMotionEnum motion) {
        this.checkNotNull();
        Raw.setMotion(this.address, axis.value, motion.value);
    }

    public PxArticulationMotionEnum getMotion(PxArticulationAxisEnum axis) {
        this.checkNotNull();
        return PxArticulationMotionEnum.forValue(Raw.getMotion(this.address, axis.value));
    }

    public void setLimitParams(PxArticulationAxisEnum axis, PxArticulationLimit limit) {
        this.checkNotNull();
        Raw.setLimitParams(this.address, axis.value, limit.getAddress());
    }

    public PxArticulationLimit getLimitParams(PxArticulationAxisEnum axis) {
        this.checkNotNull();
        return PxArticulationLimit.wrapPointer(Raw.getLimitParams(this.address, axis.value));
    }

    public void setDriveParams(PxArticulationAxisEnum axis, PxArticulationDrive drive) {
        this.checkNotNull();
        Raw.setDriveParams(this.address, axis.value, drive.getAddress());
    }

    public void setDriveTarget(PxArticulationAxisEnum axis, float target) {
        this.checkNotNull();
        Raw.setDriveTarget(this.address, axis.value, target);
    }

    public void setDriveTarget(PxArticulationAxisEnum axis, float target, boolean autowake) {
        this.checkNotNull();
        Raw.setDriveTarget(this.address, axis.value, target, autowake);
    }

    public float getDriveTarget(PxArticulationAxisEnum axis) {
        this.checkNotNull();
        return Raw.getDriveTarget(this.address, axis.value);
    }

    public void setDriveVelocity(PxArticulationAxisEnum axis, float targetVel) {
        this.checkNotNull();
        Raw.setDriveVelocity(this.address, axis.value, targetVel);
    }

    public void setDriveVelocity(PxArticulationAxisEnum axis, float targetVel, boolean autowake) {
        this.checkNotNull();
        Raw.setDriveVelocity(this.address, axis.value, targetVel, autowake);
    }

    public float getDriveVelocity(PxArticulationAxisEnum axis) {
        this.checkNotNull();
        return Raw.getDriveVelocity(this.address, axis.value);
    }

    public void setArmature(PxArticulationAxisEnum axis, float armature) {
        this.checkNotNull();
        Raw.setArmature(this.address, axis.value, armature);
    }

    public float getArmature(PxArticulationAxisEnum axis) {
        this.checkNotNull();
        return Raw.getArmature(this.address, axis.value);
    }

    public void setFrictionCoefficient(float coefficient) {
        this.checkNotNull();
        Raw.setFrictionCoefficient(this.address, coefficient);
    }

    public float getFrictionCoefficient() {
        this.checkNotNull();
        return Raw.getFrictionCoefficient(this.address);
    }

    public void setMaxJointVelocity(float maxJointV) {
        this.checkNotNull();
        Raw.setMaxJointVelocity(this.address, maxJointV);
    }

    public float getMaxJointVelocity() {
        this.checkNotNull();
        return Raw.getMaxJointVelocity(this.address);
    }

    public void setJointPosition(PxArticulationAxisEnum axis, float jointPos) {
        this.checkNotNull();
        Raw.setJointPosition(this.address, axis.value, jointPos);
    }

    public float getJointPosition(PxArticulationAxisEnum axis) {
        this.checkNotNull();
        return Raw.getJointPosition(this.address, axis.value);
    }

    public void setJointVelocity(PxArticulationAxisEnum axis, float jointVel) {
        this.checkNotNull();
        Raw.setJointVelocity(this.address, axis.value, jointVel);
    }

    public float getJointVelocity(PxArticulationAxisEnum axis) {
        this.checkNotNull();
        return Raw.getJointVelocity(this.address, axis.value);
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getParentArticulationLink(long var0);

        public static native void setParentPose(long var0, long var2);

        public static native long getParentPose(long var0);

        public static native long getChildArticulationLink(long var0);

        public static native void setChildPose(long var0, long var2);

        public static native long getChildPose(long var0);

        public static native void setJointType(long var0, int var2);

        public static native int getJointType(long var0);

        public static native void setMotion(long var0, int var2, int var3);

        public static native int getMotion(long var0, int var2);

        public static native void setLimitParams(long var0, int var2, long var3);

        public static native long getLimitParams(long var0, int var2);

        public static native void setDriveParams(long var0, int var2, long var3);

        public static native void setDriveTarget(long var0, int var2, float var3);

        public static native void setDriveTarget(long var0, int var2, float var3, boolean var4);

        public static native float getDriveTarget(long var0, int var2);

        public static native void setDriveVelocity(long var0, int var2, float var3);

        public static native void setDriveVelocity(long var0, int var2, float var3, boolean var4);

        public static native float getDriveVelocity(long var0, int var2);

        public static native void setArmature(long var0, int var2, float var3);

        public static native float getArmature(long var0, int var2);

        public static native void setFrictionCoefficient(long var0, float var2);

        public static native float getFrictionCoefficient(long var0);

        public static native void setMaxJointVelocity(long var0, float var2);

        public static native float getMaxJointVelocity(long var0);

        public static native void setJointPosition(long var0, int var2, float var3);

        public static native float getJointPosition(long var0, int var2);

        public static native void setJointVelocity(long var0, int var2, float var3);

        public static native float getJointVelocity(long var0, int var2);
    }
}

