/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.physics.PxActorFlagEnum;

public class PxActorFlags
extends NativeObject {
    public static final int SIZEOF = PxActorFlags.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxActorFlags() {
    }

    private static native int __sizeOf();

    public static PxActorFlags wrapPointer(long address) {
        return address != 0L ? new PxActorFlags(address) : null;
    }

    public static PxActorFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxActorFlags.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxActorFlags(long address) {
        super(address);
    }

    public static PxActorFlags createAt(long address, byte flags) {
        Raw.PxActorFlags_placed(address, flags);
        PxActorFlags createdObj = PxActorFlags.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxActorFlags createAt(T allocator, NativeObject.Allocator<T> allocate, byte flags) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxActorFlags_placed(address, flags);
        PxActorFlags createdObj = PxActorFlags.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxActorFlags(byte flags) {
        this.address = Raw.PxActorFlags(flags);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public boolean isSet(PxActorFlagEnum flag) {
        this.checkNotNull();
        return Raw.isSet(this.address, flag.value);
    }

    public void raise(PxActorFlagEnum flag) {
        this.checkNotNull();
        Raw.raise(this.address, flag.value);
    }

    public void clear(PxActorFlagEnum flag) {
        this.checkNotNull();
        Raw.clear(this.address, flag.value);
    }

    public static class Raw {
        public static native void PxActorFlags_placed(long var0, byte var2);

        public static native long PxActorFlags(byte var0);

        public static native void destroy(long var0);

        public static native boolean isSet(long var0, int var2);

        public static native void raise(long var0, int var2);

        public static native void clear(long var0, int var2);
    }
}

