/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxBoundedData;
import physx.common.PxTypedBoundedData_PxU16;
import physx.geometry.PxMeshFlags;
import physx.geometry.PxTetrahedronMeshFormatEnum;
import physx.support.PxArray_PxU32;
import physx.support.PxArray_PxVec3;

public class PxTetrahedronMeshDesc
extends NativeObject {
    public static final int SIZEOF = PxTetrahedronMeshDesc.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxTetrahedronMeshDesc wrapPointer(long address) {
        return address != 0L ? new PxTetrahedronMeshDesc(address) : null;
    }

    public static PxTetrahedronMeshDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxTetrahedronMeshDesc.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxTetrahedronMeshDesc(long address) {
        super(address);
    }

    public static PxTetrahedronMeshDesc createAt(long address) {
        Raw.PxTetrahedronMeshDesc_placed(address);
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTetrahedronMeshDesc createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTetrahedronMeshDesc_placed(address);
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxTetrahedronMeshDesc createAt(long address, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices) {
        Raw.PxTetrahedronMeshDesc_placed(address, meshVertices.getAddress(), meshTetIndices.getAddress());
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTetrahedronMeshDesc createAt(T allocator, NativeObject.Allocator<T> allocate, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTetrahedronMeshDesc_placed(address, meshVertices.getAddress(), meshTetIndices.getAddress());
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxTetrahedronMeshDesc createAt(long address, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat) {
        Raw.PxTetrahedronMeshDesc_placed(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value);
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTetrahedronMeshDesc createAt(T allocator, NativeObject.Allocator<T> allocate, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTetrahedronMeshDesc_placed(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value);
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxTetrahedronMeshDesc createAt(long address, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat, short numberOfTetsPerHexElement) {
        Raw.PxTetrahedronMeshDesc_placed(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value, numberOfTetsPerHexElement);
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTetrahedronMeshDesc createAt(T allocator, NativeObject.Allocator<T> allocate, PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat, short numberOfTetsPerHexElement) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTetrahedronMeshDesc_placed(address, meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value, numberOfTetsPerHexElement);
        PxTetrahedronMeshDesc createdObj = PxTetrahedronMeshDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxTetrahedronMeshDesc() {
        this.address = Raw.PxTetrahedronMeshDesc();
    }

    public PxTetrahedronMeshDesc(PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices) {
        this.address = Raw.PxTetrahedronMeshDesc(meshVertices.getAddress(), meshTetIndices.getAddress());
    }

    public PxTetrahedronMeshDesc(PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat) {
        this.address = Raw.PxTetrahedronMeshDesc(meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value);
    }

    public PxTetrahedronMeshDesc(PxArray_PxVec3 meshVertices, PxArray_PxU32 meshTetIndices, PxTetrahedronMeshFormatEnum meshFormat, short numberOfTetsPerHexElement) {
        this.address = Raw.PxTetrahedronMeshDesc(meshVertices.getAddress(), meshTetIndices.getAddress(), meshFormat.value, numberOfTetsPerHexElement);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxTypedBoundedData_PxU16 getMaterialIndices() {
        this.checkNotNull();
        return PxTypedBoundedData_PxU16.wrapPointer(Raw.getMaterialIndices(this.address));
    }

    public void setMaterialIndices(PxTypedBoundedData_PxU16 value) {
        this.checkNotNull();
        Raw.setMaterialIndices(this.address, value.getAddress());
    }

    public PxBoundedData getPoints() {
        this.checkNotNull();
        return PxBoundedData.wrapPointer(Raw.getPoints(this.address));
    }

    public void setPoints(PxBoundedData value) {
        this.checkNotNull();
        Raw.setPoints(this.address, value.getAddress());
    }

    public PxBoundedData getTetrahedrons() {
        this.checkNotNull();
        return PxBoundedData.wrapPointer(Raw.getTetrahedrons(this.address));
    }

    public void setTetrahedrons(PxBoundedData value) {
        this.checkNotNull();
        Raw.setTetrahedrons(this.address, value.getAddress());
    }

    public PxMeshFlags getFlags() {
        this.checkNotNull();
        return PxMeshFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxMeshFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public short getTetsPerElement() {
        this.checkNotNull();
        return Raw.getTetsPerElement(this.address);
    }

    public void setTetsPerElement(short value) {
        this.checkNotNull();
        Raw.setTetsPerElement(this.address, value);
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native void PxTetrahedronMeshDesc_placed(long var0);

        public static native void PxTetrahedronMeshDesc_placed(long var0, long var2, long var4);

        public static native void PxTetrahedronMeshDesc_placed(long var0, long var2, long var4, int var6);

        public static native void PxTetrahedronMeshDesc_placed(long var0, long var2, long var4, int var6, short var7);

        public static native long PxTetrahedronMeshDesc();

        public static native long PxTetrahedronMeshDesc(long var0, long var2);

        public static native long PxTetrahedronMeshDesc(long var0, long var2, int var4);

        public static native long PxTetrahedronMeshDesc(long var0, long var2, int var4, short var5);

        public static native void destroy(long var0);

        public static native long getMaterialIndices(long var0);

        public static native void setMaterialIndices(long var0, long var2);

        public static native long getPoints(long var0);

        public static native void setPoints(long var0, long var2);

        public static native long getTetrahedrons(long var0);

        public static native void setTetrahedrons(long var0, long var2);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);

        public static native short getTetsPerElement(long var0);

        public static native void setTetsPerElement(long var0, short var2);

        public static native boolean isValid(long var0);
    }
}

