/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxBoundedData;
import physx.geometry.PxMeshFlags;

public class PxSimpleTriangleMesh
extends NativeObject {
    public static final int SIZEOF = PxSimpleTriangleMesh.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxSimpleTriangleMesh wrapPointer(long address) {
        return address != 0L ? new PxSimpleTriangleMesh(address) : null;
    }

    public static PxSimpleTriangleMesh arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSimpleTriangleMesh.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSimpleTriangleMesh(long address) {
        super(address);
    }

    public PxSimpleTriangleMesh() {
        this.address = Raw.PxSimpleTriangleMesh();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxBoundedData getPoints() {
        this.checkNotNull();
        return PxBoundedData.wrapPointer(Raw.getPoints(this.address));
    }

    public void setPoints(PxBoundedData value) {
        this.checkNotNull();
        Raw.setPoints(this.address, value.getAddress());
    }

    public PxBoundedData getTriangles() {
        this.checkNotNull();
        return PxBoundedData.wrapPointer(Raw.getTriangles(this.address));
    }

    public void setTriangles(PxBoundedData value) {
        this.checkNotNull();
        Raw.setTriangles(this.address, value.getAddress());
    }

    public PxMeshFlags getFlags() {
        this.checkNotNull();
        return PxMeshFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxMeshFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native long PxSimpleTriangleMesh();

        public static native void destroy(long var0);

        public static native long getPoints(long var0);

        public static native void setPoints(long var0, long var2);

        public static native long getTriangles(long var0);

        public static native void setTriangles(long var0, long var2);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);

        public static native void setToDefault(long var0);

        public static native boolean isValid(long var0);
    }
}

