/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.geometry.PxMeshFlagEnum;

public class PxMeshFlags
extends NativeObject {
    public static final int SIZEOF = PxMeshFlags.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxMeshFlags() {
    }

    private static native int __sizeOf();

    public static PxMeshFlags wrapPointer(long address) {
        return address != 0L ? new PxMeshFlags(address) : null;
    }

    public static PxMeshFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxMeshFlags.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxMeshFlags(long address) {
        super(address);
    }

    public static PxMeshFlags createAt(long address, byte flags) {
        Raw.PxMeshFlags_placed(address, flags);
        PxMeshFlags createdObj = PxMeshFlags.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxMeshFlags createAt(T allocator, NativeObject.Allocator<T> allocate, byte flags) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxMeshFlags_placed(address, flags);
        PxMeshFlags createdObj = PxMeshFlags.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxMeshFlags(byte flags) {
        this.address = Raw.PxMeshFlags(flags);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public boolean isSet(PxMeshFlagEnum flag) {
        this.checkNotNull();
        return Raw.isSet(this.address, flag.value);
    }

    public void raise(PxMeshFlagEnum flag) {
        this.checkNotNull();
        Raw.raise(this.address, flag.value);
    }

    public void clear(PxMeshFlagEnum flag) {
        this.checkNotNull();
        Raw.clear(this.address, flag.value);
    }

    public static class Raw {
        public static native void PxMeshFlags_placed(long var0, byte var2);

        public static native long PxMeshFlags(byte var0);

        public static native void destroy(long var0);

        public static native boolean isSet(long var0, int var2);

        public static native void raise(long var0, int var2);

        public static native void clear(long var0, int var2);
    }
}

