/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.geometry.PxBoxGeometry;
import physx.geometry.PxCapsuleGeometry;
import physx.geometry.PxConvexMeshGeometry;
import physx.geometry.PxGeometry;
import physx.geometry.PxGeometryTypeEnum;
import physx.geometry.PxHeightFieldGeometry;
import physx.geometry.PxPlaneGeometry;
import physx.geometry.PxSphereGeometry;
import physx.geometry.PxTriangleMeshGeometry;

public class PxGeometryHolder
extends NativeObject {
    public static final int SIZEOF = PxGeometryHolder.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxGeometryHolder wrapPointer(long address) {
        return address != 0L ? new PxGeometryHolder(address) : null;
    }

    public static PxGeometryHolder arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxGeometryHolder.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxGeometryHolder(long address) {
        super(address);
    }

    public PxGeometryHolder() {
        this.address = Raw.PxGeometryHolder();
    }

    public PxGeometryHolder(PxGeometry geometry) {
        this.address = Raw.PxGeometryHolder(geometry.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxGeometryTypeEnum getType() {
        this.checkNotNull();
        return PxGeometryTypeEnum.forValue(Raw.getType(this.address));
    }

    public PxSphereGeometry sphere() {
        this.checkNotNull();
        return PxSphereGeometry.wrapPointer(Raw.sphere(this.address));
    }

    public PxPlaneGeometry plane() {
        this.checkNotNull();
        return PxPlaneGeometry.wrapPointer(Raw.plane(this.address));
    }

    public PxCapsuleGeometry capsule() {
        this.checkNotNull();
        return PxCapsuleGeometry.wrapPointer(Raw.capsule(this.address));
    }

    public PxBoxGeometry box() {
        this.checkNotNull();
        return PxBoxGeometry.wrapPointer(Raw.box(this.address));
    }

    public PxConvexMeshGeometry convexMesh() {
        this.checkNotNull();
        return PxConvexMeshGeometry.wrapPointer(Raw.convexMesh(this.address));
    }

    public PxTriangleMeshGeometry triangleMesh() {
        this.checkNotNull();
        return PxTriangleMeshGeometry.wrapPointer(Raw.triangleMesh(this.address));
    }

    public PxHeightFieldGeometry heightField() {
        this.checkNotNull();
        return PxHeightFieldGeometry.wrapPointer(Raw.heightField(this.address));
    }

    public void storeAny(PxGeometry geometry) {
        this.checkNotNull();
        Raw.storeAny(this.address, geometry.getAddress());
    }

    public static class Raw {
        public static native long PxGeometryHolder();

        public static native long PxGeometryHolder(long var0);

        public static native void destroy(long var0);

        public static native int getType(long var0);

        public static native long sphere(long var0);

        public static native long plane(long var0);

        public static native long capsule(long var0);

        public static native long box(long var0);

        public static native long convexMesh(long var0);

        public static native long triangleMesh(long var0);

        public static native long heightField(long var0);

        public static native void storeAny(long var0, long var2);
    }
}

