/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.PlatformChecks;
import physx.geometry.PxGeometry;
import physx.geometry.SimpleCustomGeometryCallbacks;

public class PxCustomGeometry
extends PxGeometry {
    public static final int SIZEOF;
    public static final int ALIGNOF = 8;

    protected PxCustomGeometry() {
    }

    private static native int __sizeOf();

    public static PxCustomGeometry wrapPointer(long address) {
        return address != 0L ? new PxCustomGeometry(address) : null;
    }

    public static PxCustomGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxCustomGeometry.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxCustomGeometry(long address) {
        super(address);
    }

    public PxCustomGeometry(SimpleCustomGeometryCallbacks callbacks) {
        this.address = Raw.PxCustomGeometry(callbacks.getAddress());
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    static {
        PlatformChecks.requirePlatform(15, "physx.geometry.PxCustomGeometry");
        SIZEOF = PxCustomGeometry.__sizeOf();
    }

    public static class Raw {
        public static native long PxCustomGeometry(long var0);

        public static native void destroy(long var0);

        public static native boolean isValid(long var0);
    }
}

