/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.common.PxBounds3;
import physx.common.PxRefCounted;
import physx.common.PxVec3;
import physx.geometry.PxHullPolygon;
import physx.support.PxU8ConstPtr;

public class PxConvexMesh
extends PxRefCounted {
    public static final int SIZEOF = PxConvexMesh.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxConvexMesh() {
    }

    private static native int __sizeOf();

    public static PxConvexMesh wrapPointer(long address) {
        return address != 0L ? new PxConvexMesh(address) : null;
    }

    public static PxConvexMesh arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxConvexMesh.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxConvexMesh(long address) {
        super(address);
    }

    public int getNbVertices() {
        this.checkNotNull();
        return Raw.getNbVertices(this.address);
    }

    public PxVec3 getVertices() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getVertices(this.address));
    }

    public PxU8ConstPtr getIndexBuffer() {
        this.checkNotNull();
        return PxU8ConstPtr.wrapPointer(Raw.getIndexBuffer(this.address));
    }

    public int getNbPolygons() {
        this.checkNotNull();
        return Raw.getNbPolygons(this.address);
    }

    public boolean getPolygonData(int index, PxHullPolygon data) {
        this.checkNotNull();
        return Raw.getPolygonData(this.address, index, data.getAddress());
    }

    public PxBounds3 getLocalBounds() {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getLocalBounds(this.address));
    }

    public boolean isGpuCompatible() {
        this.checkNotNull();
        return Raw.isGpuCompatible(this.address);
    }

    public static class Raw {
        public static native int getNbVertices(long var0);

        public static native long getVertices(long var0);

        public static native long getIndexBuffer(long var0);

        public static native int getNbPolygons(long var0);

        public static native boolean getPolygonData(long var0, int var2, long var3);

        public static native long getLocalBounds(long var0);

        public static native boolean isGpuCompatible(long var0);
    }
}

