/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxContactPoint
extends NativeObject {
    public static final int SIZEOF = PxContactPoint.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxContactPoint wrapPointer(long address) {
        return address != 0L ? new PxContactPoint(address) : null;
    }

    public static PxContactPoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxContactPoint.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxContactPoint(long address) {
        super(address);
    }

    public PxContactPoint() {
        this.address = Raw.PxContactPoint();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getNormal() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getNormal(this.address));
    }

    public void setNormal(PxVec3 value) {
        this.checkNotNull();
        Raw.setNormal(this.address, value.getAddress());
    }

    public PxVec3 getPoint() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getPoint(this.address));
    }

    public void setPoint(PxVec3 value) {
        this.checkNotNull();
        Raw.setPoint(this.address, value.getAddress());
    }

    public PxVec3 getTargetVel() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getTargetVel(this.address));
    }

    public void setTargetVel(PxVec3 value) {
        this.checkNotNull();
        Raw.setTargetVel(this.address, value.getAddress());
    }

    public float getSeparation() {
        this.checkNotNull();
        return Raw.getSeparation(this.address);
    }

    public void setSeparation(float value) {
        this.checkNotNull();
        Raw.setSeparation(this.address, value);
    }

    public float getMaxImpulse() {
        this.checkNotNull();
        return Raw.getMaxImpulse(this.address);
    }

    public void setMaxImpulse(float value) {
        this.checkNotNull();
        Raw.setMaxImpulse(this.address, value);
    }

    public float getStaticFriction() {
        this.checkNotNull();
        return Raw.getStaticFriction(this.address);
    }

    public void setStaticFriction(float value) {
        this.checkNotNull();
        Raw.setStaticFriction(this.address, value);
    }

    public byte getMaterialFlags() {
        this.checkNotNull();
        return Raw.getMaterialFlags(this.address);
    }

    public void setMaterialFlags(byte value) {
        this.checkNotNull();
        Raw.setMaterialFlags(this.address, value);
    }

    public int getInternalFaceIndex1() {
        this.checkNotNull();
        return Raw.getInternalFaceIndex1(this.address);
    }

    public void setInternalFaceIndex1(int value) {
        this.checkNotNull();
        Raw.setInternalFaceIndex1(this.address, value);
    }

    public float getDynamicFriction() {
        this.checkNotNull();
        return Raw.getDynamicFriction(this.address);
    }

    public void setDynamicFriction(float value) {
        this.checkNotNull();
        Raw.setDynamicFriction(this.address, value);
    }

    public float getRestitution() {
        this.checkNotNull();
        return Raw.getRestitution(this.address);
    }

    public void setRestitution(float value) {
        this.checkNotNull();
        Raw.setRestitution(this.address, value);
    }

    public float getDamping() {
        this.checkNotNull();
        return Raw.getDamping(this.address);
    }

    public void setDamping(float value) {
        this.checkNotNull();
        Raw.setDamping(this.address, value);
    }

    public static class Raw {
        public static native long PxContactPoint();

        public static native void destroy(long var0);

        public static native long getNormal(long var0);

        public static native void setNormal(long var0, long var2);

        public static native long getPoint(long var0);

        public static native void setPoint(long var0, long var2);

        public static native long getTargetVel(long var0);

        public static native void setTargetVel(long var0, long var2);

        public static native float getSeparation(long var0);

        public static native void setSeparation(long var0, float var2);

        public static native float getMaxImpulse(long var0);

        public static native void setMaxImpulse(long var0, float var2);

        public static native float getStaticFriction(long var0);

        public static native void setStaticFriction(long var0, float var2);

        public static native byte getMaterialFlags(long var0);

        public static native void setMaterialFlags(long var0, byte var2);

        public static native int getInternalFaceIndex1(long var0);

        public static native void setInternalFaceIndex1(long var0, int var2);

        public static native float getDynamicFriction(long var0);

        public static native void setDynamicFriction(long var0, float var2);

        public static native float getRestitution(long var0);

        public static native void setRestitution(long var0, float var2);

        public static native float getDamping(long var0);

        public static native void setDamping(long var0, float var2);
    }
}

