/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxVec3;
import physx.geometry.PxContactPoint;

public class PxContactBuffer
extends NativeObject {
    public static final int SIZEOF = PxContactBuffer.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxContactBuffer() {
    }

    private static native int __sizeOf();

    public static PxContactBuffer wrapPointer(long address) {
        return address != 0L ? new PxContactBuffer(address) : null;
    }

    public static PxContactBuffer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxContactBuffer.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxContactBuffer(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxContactPoint getContacts(int index) {
        this.checkNotNull();
        return PxContactPoint.wrapPointer(Raw.getContacts(this.address, index));
    }

    public void setContacts(int index, PxContactPoint value) {
        this.checkNotNull();
        Raw.setContacts(this.address, index, value.getAddress());
    }

    public int getCount() {
        this.checkNotNull();
        return Raw.getCount(this.address);
    }

    public void setCount(int value) {
        this.checkNotNull();
        Raw.setCount(this.address, value);
    }

    public int getPad() {
        this.checkNotNull();
        return Raw.getPad(this.address);
    }

    public void setPad(int value) {
        this.checkNotNull();
        Raw.setPad(this.address, value);
    }

    public static int getMAX_CONTACTS() {
        return Raw.getMAX_CONTACTS();
    }

    public void reset() {
        this.checkNotNull();
        Raw.reset(this.address);
    }

    public boolean contact(PxVec3 worldPoint, PxVec3 worldNormalIn, float separation) {
        this.checkNotNull();
        return Raw.contact(this.address, worldPoint.getAddress(), worldNormalIn.getAddress(), separation);
    }

    public boolean contact(PxVec3 worldPoint, PxVec3 worldNormalIn, float separation, int faceIndex1) {
        this.checkNotNull();
        return Raw.contact(this.address, worldPoint.getAddress(), worldNormalIn.getAddress(), separation, faceIndex1);
    }

    public boolean contact(PxContactPoint pt) {
        this.checkNotNull();
        return Raw.contact(this.address, pt.getAddress());
    }

    public PxContactPoint contact() {
        this.checkNotNull();
        PlatformChecks.requirePlatform(15, "physx.geometry.PxContactBuffer");
        return PxContactPoint.wrapPointer(Raw.contact(this.address));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getContacts(long var0, int var2);

        public static native void setContacts(long var0, int var2, long var3);

        public static native int getCount(long var0);

        public static native void setCount(long var0, int var2);

        public static native int getPad(long var0);

        public static native void setPad(long var0, int var2);

        public static native int getMAX_CONTACTS();

        public static native void reset(long var0);

        public static native boolean contact(long var0, long var2, long var4, float var6);

        public static native boolean contact(long var0, long var2, long var4, float var6, int var7);

        public static native boolean contact(long var0, long var2);

        public static native long contact(long var0);
    }
}

